/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.cooldown;

import de.tobiyas.racesandclasses.APIs.CooldownApi;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class PlayerCooldownDragonBarManager {
    private final RaCPlayer player;
    private final Map<String, BossBar> map = new HashMap<String, BossBar>();

    public PlayerCooldownDragonBarManager(RaCPlayer player) {
        this.player = player;
    }

    public void tick() {
        Player player = this.player.getPlayer();
        if (player == null || !player.isOnline()) {
            if (!this.map.isEmpty()) {
                for (BossBar bar : this.map.values()) {
                    bar.removeAll();
                    bar.setVisible(false);
                }
                this.map.clear();
            }
            return;
        }
        String playerName = player.getName();
        Map<String, Integer> cooldowns = CooldownApi.getAllCooldownsForPlayer(playerName);
        for (Map.Entry<String, Integer> entry : cooldowns.entrySet()) {
            String trait = entry.getKey();
            double remaining = entry.getValue().intValue();
            double max = CooldownApi.getMaxCooldownForTrait(playerName, trait);
            BossBar bar = this.map.get(trait);
            if (bar == null && remaining <= 0.0) continue;
            if (bar == null && remaining > 0.0) {
                bar = Bukkit.createBossBar((String)trait, (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
                bar.addPlayer(player);
                continue;
            }
            if (bar != null && remaining <= 0.0) {
                bar.setVisible(false);
                continue;
            }
            if (bar == null || !(remaining > 0.0)) continue;
            double value = remaining / max;
            value = Math.min(Math.max(0.0, value), 1.0);
            bar.setProgress(value);
            if (bar.isVisible()) continue;
            bar.setVisible(true);
        }
    }
}

