/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.cooldown;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.cooldown.CooldownContainer;
import de.tobiyas.racesandclasses.cooldown.CooldownList;
import de.tobiyas.racesandclasses.cooldown.PlayerCooldownDragonBarManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CooldownManager {
    protected CooldownList cooldownList;
    private int taskId;
    private final Map<RaCPlayer, PlayerCooldownDragonBarManager> bars = new HashMap<RaCPlayer, PlayerCooldownDragonBarManager>();

    public CooldownManager() {
        this.cooldownList = new CooldownList();
    }

    public void init() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)new UplinkReducingTask(), 20L, 20L);
    }

    public void shutdown() {
        Bukkit.getScheduler().cancelTask(this.taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stillHasCooldown(String player, String cooldownName) {
        CooldownList cooldownList = this.cooldownList;
        synchronized (cooldownList) {
            block4: {
                if (this.cooldownList.contains(player, cooldownName)) break block4;
                return -1;
            }
            return this.cooldownList.get(player, cooldownName).getCooldownTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCooldown(String player, String cooldownName, int time) {
        CooldownList cooldownList = this.cooldownList;
        synchronized (cooldownList) {
            if (time <= 0) {
                this.cooldownList.remove(player, cooldownName);
            } else {
                this.cooldownList.add(player, cooldownName, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCooldownsOfPlayer(String playerName) {
        LinkedList<String> playerCooldownList = new LinkedList<String>();
        CooldownList cooldownList = this.cooldownList;
        synchronized (cooldownList) {
            for (CooldownContainer container : this.cooldownList) {
                if (!container.getPlayerName().equalsIgnoreCase(playerName)) continue;
                playerCooldownList.add(container.getCooldownName());
            }
        }
        return playerCooldownList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getAllCooldownsForPlayer(String playerName) {
        HashMap<String, Integer> playerCooldownMap = new HashMap<String, Integer>();
        CooldownList cooldownList = this.cooldownList;
        synchronized (cooldownList) {
            for (CooldownContainer container : this.cooldownList) {
                if (!container.getPlayerName().equalsIgnoreCase(playerName)) continue;
                playerCooldownMap.put(container.getCooldownName(), container.getCooldownTime());
            }
        }
        return playerCooldownMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick() {
        if (this.cooldownList.isEmpty()) {
            return;
        }
        CooldownList cooldownList = this.cooldownList;
        synchronized (cooldownList) {
            this.cooldownList.tickAll();
        }
        if (RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_useDragonBarForCooldown()) {
            for (Player player : PlayerUtils.getOnlinePlayers()) {
                RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
                PlayerCooldownDragonBarManager bar = this.bars.get(racPlayer);
                if (bar == null) {
                    bar = new PlayerCooldownDragonBarManager(racPlayer);
                    this.bars.put(racPlayer, bar);
                }
                bar.tick();
            }
        }
    }

    public void clearAllCooldowns() {
        this.cooldownList.clear();
    }

    protected class UplinkReducingTask
    implements Runnable {
        protected UplinkReducingTask() {
        }

        @Override
        public void run() {
            CooldownManager.this.tick();
        }
    }
}

