/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.cooldown;

import de.tobiyas.racesandclasses.cooldown.CooldownContainer;
import java.util.LinkedList;

public class CooldownList
extends LinkedList<CooldownContainer> {
    private static final long serialVersionUID = 4706011594354900363L;

    public boolean contains(String playerName, String cooldownName) {
        return this.get(playerName, cooldownName) != null;
    }

    public CooldownContainer get(String playerName, String cooldownName) {
        for (CooldownContainer container : this) {
            if (!container.getPlayerName().equalsIgnoreCase(playerName) || !container.getCooldownName().equalsIgnoreCase(cooldownName)) continue;
            return container;
        }
        return null;
    }

    public CooldownContainer remove(String playerName, String cooldownName) {
        CooldownContainer container = this.get(playerName, cooldownName);
        if (container != null) {
            this.remove(container);
        }
        return container;
    }

    public void add(String playerName, String cooldownName, int cooldownTime) {
        this.remove(playerName, cooldownName);
        this.add(new CooldownContainer(playerName, cooldownName, cooldownTime));
    }

    public void tickAll() {
        LinkedList<CooldownContainer> remove = new LinkedList<CooldownContainer>();
        for (CooldownContainer container : this) {
            container.tick();
            if (container.getCooldownTime() > 0) continue;
            remove.add(container);
        }
        for (CooldownContainer removed : remove) {
            this.remove(removed);
        }
    }
}

