/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration.traits;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.racesandclasses.util.items.CreateDropContainer;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.io.IOException;

public class DefaultTraitConfig {
    public static void createDefaultTraitConfig() {
        DefaultTraitConfig.createTraitConfig("TrollbloodTrait", "trait.uplink", 60, false);
        DefaultTraitConfig.createTraitConfig("TrollbloodTrait", "trait.iteminhand", 260, true);
        DefaultTraitConfig.createTraitConfig("SprintTrait", "trait.uplink", 40, false);
        DefaultTraitConfig.createTraitConfig("SprintTrait", "trait.iteminhand", 260, true);
        DefaultTraitConfig.createTraitConfig("TeleportArrowTrait", "trait.uplink", 60, false);
        DefaultTraitConfig.createTraitConfig("STDAxeDamageTrait", "trait.damage.wood", 4, true);
        DefaultTraitConfig.createTraitConfig("STDAxeDamageTrait", "trait.damage.stone", 5, true);
        DefaultTraitConfig.createTraitConfig("STDAxeDamageTrait", "trait.damage.gold", 4, true);
        DefaultTraitConfig.createTraitConfig("STDAxeDamageTrait", "trait.damage.iron", 6, true);
        DefaultTraitConfig.createTraitConfig("STDAxeDamageTrait", "trait.damage.diamond", 7, true);
        DefaultTraitConfig.createTraitConfig("HealOthersTrait", "trait.uplink", 60, true);
        DefaultTraitConfig.createTraitConfig("HealOthersTrait", "trait.iteminhand", 287, true);
        DefaultTraitConfig.createTraitConfig("BerserkerRageTrait", "trait.uplink", 60, true);
        DefaultTraitConfig.createTraitConfig("BerserkerRageTrait", "trait.duration", 10, true);
        DefaultTraitConfig.createTraitConfig("BerserkerRageTrait", "trait.activationLimit", 30, true);
        DefaultTraitConfig.createTraitConfig("DwarfSkinTrait", "trait.uplink", 60, true);
        DefaultTraitConfig.createTraitConfig("DwarfSkinTrait", "trait.duration", 10, true);
        DefaultTraitConfig.createTraitConfig("DwarfSkinTrait", "trait.activationLimit", 30, true);
        DefaultTraitConfig.createTraitConfig("LastStandTrait", "trait.uplink", 60, true);
        DefaultTraitConfig.createTraitConfig("LastStandTrait", "trait.activationLimit", 30, true);
        String dropContainerPath = String.valueOf(Consts.traitConfigDir) + "DropRates.yml";
        CreateDropContainer.createAllContainers(dropContainerPath);
    }

    private static void createTraitConfig(String traitName, String config, Object value, boolean force) {
        YAMLConfigExtended yamlConfig = DefaultTraitConfig.createYAMLIfNotExist(traitName, force);
        if (yamlConfig == null) {
            return;
        }
        if (!yamlConfig.isInt(config)) {
            yamlConfig.set(config, value);
        }
        yamlConfig.save();
    }

    private static YAMLConfigExtended createYAMLIfNotExist(String traitName, boolean force) {
        YAMLConfigExtended config;
        File file = new File(Consts.traitConfigDir, String.valueOf(traitName) + ".yml");
        if (file.exists()) {
            if (!force) {
                return null;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                RacesAndClasses.getPlugin().log("Could not create file: " + file.toString());
                return null;
            }
        }
        if ((config = new YAMLConfigExtended(file.toString()).load()).getValidLoad()) {
            return config;
        }
        return null;
    }
}

