/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration.statusimun;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.statusimun.StatusEffect;
import de.tobiyas.racesandclasses.configuration.statusimun.StatusImunContainer;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StatusImunManager {
    public final Map<String, StatusImunContainer> containerMap = new HashMap<String, StatusImunContainer>();

    public void reload() {
        this.containerMap.clear();
        File file = new File(RacesAndClasses.getPlugin().getDataFolder(), "StatusImun.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        YAMLConfigExtended config = new YAMLConfigExtended(file).load();
        for (String name : config.getRootChildren()) {
            List<String> imun = config.getStringList(name);
            if (imun == null || imun.isEmpty()) continue;
            HashSet<StatusEffect> effects = new HashSet<StatusEffect>();
            for (String imunString : imun) {
                StatusEffect ef = StatusEffect.resolve(imunString);
                if (ef == null) continue;
                effects.add(ef);
            }
            this.containerMap.put(name, new StatusImunContainer(name, effects));
        }
    }

    public boolean isImun(String name, StatusEffect effect) {
        if (name == null || name.isEmpty() || effect == null) {
            return false;
        }
        StatusImunContainer container = this.containerMap.get(name);
        return container == null ? false : container.isImun(effect);
    }
}

