/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration.racetoclass;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.racetoclass.RaceNotFoundException;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RaceToClassConfiguration {
    private YAMLConfigExtended racesClassesSelectionMatrix;
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private String pathToConfigFile;
    private Map<String, List<String>> selectionMatrix = new HashMap<String, List<String>>();

    public RaceToClassConfiguration() {
        this.pathToConfigFile = String.valueOf(this.plugin.getDataFolder().getAbsolutePath()) + File.separator + "racesClassesSelectionMatrix.yml";
        this.racesClassesSelectionMatrix = new YAMLConfigExtended(this.pathToConfigFile);
    }

    public void reload() {
        this.racesClassesSelectionMatrix.load();
        if (!this.racesClassesSelectionMatrix.getValidLoad()) {
            this.plugin.log("The File: " + this.pathToConfigFile + "' could not be loaded correct. The Selection Matrix is empty.");
            return;
        }
        Set<String> races = this.racesClassesSelectionMatrix.getRootChildren();
        for (String race : races) {
            if (!this.racesClassesSelectionMatrix.isList(race)) {
                this.plugin.log("The Race " + race + " in the file: '" + this.pathToConfigFile + "' has no List as argument. Skiping it.");
                continue;
            }
            List<String> classList = this.racesClassesSelectionMatrix.getStringList(race);
            this.selectionMatrix.put(race, classList);
        }
    }

    public List<String> getClassesValidForRace(String raceName) throws RaceNotFoundException {
        if (!this.selectionMatrix.containsKey(raceName)) {
            throw new RaceNotFoundException();
        }
        return this.selectionMatrix.get(raceName);
    }

    public boolean isValidCombination(String raceName, String className) {
        raceName = raceName.toLowerCase();
        className = className.toLowerCase();
        for (String orgRaceMatrix : this.selectionMatrix.keySet()) {
            String raceMatrix = orgRaceMatrix.toLowerCase();
            if (!raceMatrix.equals(raceName)) continue;
            for (String classMatrix : this.selectionMatrix.get(orgRaceMatrix)) {
                if (!(classMatrix = classMatrix.toLowerCase()).equals(className)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

