/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration.global;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.ConfigTemplate;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelCalculator;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelingSystem;
import de.tobiyas.racesandclasses.playermanagement.leveling.manager.McMMOLevelManager;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaManagerType;
import de.tobiyas.racesandclasses.util.items.WandItem;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.evaluations.EvalEvaluator;
import de.tobiyas.util.RaC.formating.Pair;
import de.tobiyas.util.RaC.sql.SQL;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;

public class GeneralConfig {
    private final RacesAndClasses plugin;
    private boolean config_racechat_encrypt;
    private double config_defaultHealth;
    private boolean config_adaptListName;
    private boolean config_whisper_enable;
    private boolean config_enableDebugOutputs;
    private boolean config_enableErrorUpload;
    private boolean config_classes_enable;
    private boolean config_channels_enable;
    private boolean config_metrics_enabled;
    private boolean config_activate_reminder;
    private int config_reminder_interval;
    private boolean config_enable_expDropBonus;
    private boolean config_enable_healthbar_in_chat;
    private boolean config_enable_permanent_scoreboard;
    private boolean config_disableHealthMods;
    private boolean config_enableRaceTeams;
    private boolean config_useNewTraitBindSystem;
    private boolean config_usePermissionsForRaces;
    private boolean config_usePermissionsForClasses;
    private boolean config_useRaceClassSelectionMatrix;
    private boolean config_food_enabled;
    private boolean config_convert;
    private boolean config_convert_toDB_orFile;
    private boolean config_mana_use_xp_bar;
    private boolean config_useSkillSystem;
    private int config_skillpointEveryXLevel;
    private String config_usedLanguage;
    private String config_serializer;
    private String config_database_host;
    private int config_database_port;
    private String config_database_db;
    private String config_database_username;
    private String config_database_password;
    private boolean config_preload_data_async;
    private int config_preload_bulk_amount;
    private List<String> config_worldsDisabled;
    private boolean config_keep_max_hp_on_disabled_worlds;
    private int config_raceChangeCommandUplink;
    private int config_classChangeCommandUplink;
    private List<String> config_general_disable_commands;
    private boolean config_useClassGUIToSelect;
    private boolean config_useRaceGUIToSelect;
    private boolean config_openRaceSelectionOnJoinWhenNoRace;
    private boolean config_openClassSelectionAfterRaceSelectionWhenNoClass;
    private boolean config_cancleGUIExitWhenNoRacePresent;
    private boolean config_cancleGUIExitWhenNoClassPresent;
    private String config_takeClassWhenNoClass;
    private String config_takeRaceWhenNoRace;
    private String config_defaultRaceName;
    private String config_defaultRaceTag;
    private String config_actionbar_format;
    private double config_magic_sprintingManaCost;
    private int config_magic_sprintingManaDrainInterval;
    private boolean config_magic_manaRefillWhileSprinting;
    private WandItem config_itemForMagic;
    private String config_mapExpPerLevelCalculationString;
    private LevelingSystem config_useLevelSystem;
    private boolean config_savePlayerDataToDB;
    private int config_debugTimeAfterLoginOpening;
    private boolean config_useAutoUpdater;
    private boolean config_alsoUseLeftClickInGuis;
    private boolean config_disableAllScoreboardOutputs;
    private boolean config_enableRaces;
    private boolean config_classes_removeClassOnRaceChange;
    private boolean config_disableArmorChecking;
    private boolean config_disableChatJoinLeaveMessages;
    private boolean config_enableRaceSpawn;
    private boolean config_enableRaceSpawnOnDeath;
    private int config_raceSpawnCooldown;
    private int config_cooldown_on_bow_message;
    private int config_cooldown_on_wand_message;
    private int config_max_level;
    private boolean config_groups_enable;
    private String config_groups_system;
    private boolean config_use_permissions_for_hotkeys;
    private boolean config_useDragonBarForCooldown;
    private List<String> config_general_disable_aliases;
    private boolean config_gui_level_useMCLevelBar;
    private Material config_hotkeys_material;
    private List<String> config_race_commands_after_change;
    private List<String> config_class_commands_after_change;
    private int config_general_remove_old_data_days;
    private boolean config_general_remove_old_data_check_empty;
    private boolean config_useFoodManaBar;
    private ManaManagerType config_manaManagerType;
    private String config_gui_scoreboard_name;
    private boolean config_races_create_group_for_race;
    private boolean config_hotkeysEnabled;
    private boolean config_use_fireworks_on_level_up;
    private boolean config_use_levelup_message;
    private Pair<Double, Double> config_magic_outOfFightRegeneration = new Pair<Double, Double>(0.0, 100.0);
    private final Set<String> config_disabled_regions = new HashSet<String>();
    private final Set<String> config_npc_select_race = new HashSet<String>();
    private final Set<String> config_npc_change_race = new HashSet<String>();
    private final Set<String> config_npc_select_class = new HashSet<String>();
    private final Set<String> config_npc_change_class = new HashSet<String>();
    private final Map<EntityType, Integer> config_custom_level_exp_gain = new HashMap<EntityType, Integer>();
    private final Set<Integer> config_disabledHotkeySlots = new HashSet<Integer>();
    private final Map<String, String> config_command_remaps = new HashMap<String, String>();

    public GeneralConfig() {
        this.plugin = RacesAndClasses.getPlugin();
        this.checkRegenerate(false);
    }

    public void checkRegenerate(boolean force) {
        this.setupConfiguration();
        this.reload();
        ConfigTemplate template = new ConfigTemplate();
        if (force || template.isOldConfigVersion()) {
            template.writeTemplate();
        }
    }

    private void setupConfiguration() {
        FileConfiguration config = this.plugin.getConfig();
        config.addDefault("chat_whisper_enable", (Object)true);
        config.addDefault("chat_race_encryptForOthers", (Object)false);
        config.addDefault("chat_channel_enable", (Object)true);
        config.addDefault("chat_disable_channel_join_leave_messages", (Object)false);
        config.addDefault("health_defaultHealth", (Object)20);
        config.addDefault("health_bar_inChat_enable", (Object)true);
        config.addDefault("debug_outputs_enable", (Object)true);
        config.addDefault("debug_outputs_errorUpload", (Object)true);
        config.addDefault("classes_enable", (Object)true);
        config.addDefault("metrics_enable", (Object)true);
        config.addDefault("updater_enableAutoUpdates", (Object)false);
        config.addDefault("hotkeys_enabled", (Object)true);
        config.addDefault("hotkeys_material", (Object)Material.SHEARS.name());
        config.addDefault("use_new_traitbind_system", (Object)true);
        config.addDefault("use_permissions_for_hotkeys", (Object)false);
        config.addDefault("races_remindDefaultRace_enable", (Object)true);
        config.addDefault("races_remindDefaultRace_interval", (Object)10);
        config.addDefault("races_display_adaptListName", (Object)true);
        config.addDefault("races_drops_enable", (Object)true);
        config.addDefault("races_create_group_for_race", (Object)true);
        config.addDefault("races_permissions_usePermissionsForEachRace", (Object)false);
        config.addDefault("races_change_uplinkInSeconds", (Object)0);
        config.addDefault("races_defaultrace_name", (Object)"DefaultRace");
        config.addDefault("races_defaultrace_tag", (Object)"[NoRace]");
        config.addDefault("races_openRaceSelectionOnJoinWhenNoRace_enable", (Object)true);
        config.addDefault("races_openRaceSelectionOnJoinWhenNoRace_timeToOpenAfterLoginInSeconds", (Object)2);
        config.addDefault("races_cancleGUIExitWhenNoRacePresent_enable", (Object)true);
        config.addDefault("races_takeRaceWhenNoRace", (Object)"");
        config.addDefault("classes_permissions_usePermissionsForEachClasses", (Object)false);
        config.addDefault("classes_removeClassOnRaceChange", (Object)false);
        config.addDefault("classes_useRaceClassSelectionMatrix", (Object)false);
        config.addDefault("classes_change_uplinkInSeconds", (Object)0);
        config.addDefault("classes_openClassSelectionAfterRaceSelectionWhenNoClass_enable", (Object)true);
        config.addDefault("classes_cancleGUIExitWhenNoClassPresent_enable", (Object)true);
        config.addDefault("classes_takeClassWhenNoClass", (Object)"");
        config.addDefault("language_used", (Object)"en");
        config.addDefault("gui_level_useMCLevelBar", (Object)false);
        config.addDefault("magic_useFoodManaBar", (Object)false);
        config.addDefault("worlds_disableOn", Arrays.asList("demoWorld", "demoWorld2"));
        config.addDefault("keep_max_hp_on_disabled_worlds", (Object)true);
        config.addDefault("general_convert_database_on_startup", (Object)true);
        config.addDefault("general_disable_commands", new LinkedList());
        config.addDefault("general_disable_aliases", new LinkedList());
        config.addDefault("general_cooldown_on_wand_message", (Object)10);
        config.addDefault("general_cooldown_on_bow_message", (Object)10);
        config.addDefault("general_remove_old_data_days", (Object)60);
        config.addDefault("general_remove_old_data_check_empty", (Object)true);
        config.addDefault("serialize_serializer_to_use", (Object)"yml");
        config.addDefault("serialize_preload_data_async", (Object)true);
        config.addDefault("serialize_preload_bulk_amount", (Object)100000);
        config.addDefault("serialize_database_host", (Object)"localhost");
        config.addDefault("serialize_database_port", (Object)3306);
        config.addDefault("serialize_database_db", (Object)"RaC");
        config.addDefault("serialize_database_username", (Object)"username");
        config.addDefault("serialize_database_password", (Object)"password");
        config.addDefault("serialize_convert", (Object)true);
        config.addDefault("serialize_convert_to_DB_or_file", (Object)false);
        config.addDefault("gui_scoreboard_disableAllOutputs", (Object)false);
        config.addDefault("gui_scoreboard_name", (Object)"&eRaC");
        config.addDefault("gui_enable_permanent_scoreboard", (Object)false);
        config.addDefault("gui_alsoUseLeftclickInGuis", (Object)true);
        config.addDefault("gui_actionbar_format", (Object)"%manabar% &eLvL: %level%  &eExp: %expbar%");
        config.addDefault("races_gui_enable", (Object)true);
        config.addDefault("classes_gui_enable", (Object)true);
        config.addDefault("magic_wandId", (Object)Material.STICK.name());
        config.addDefault("magic_manaManagerType", (Object)ManaManagerType.RaC.name());
        config.addDefault("magic_outOfFightRegeneration", (Object)"0#100");
        config.addDefault("magic_sprintingManaDrainInterval", (Object)3);
        config.addDefault("magic_sprintingManaCost", (Object)2);
        config.addDefault("magic_manaRefillWhileSprinting", (Object)true);
        config.addDefault("magic_mana_use_xp_bar", (Object)false);
        config.addDefault("level_mapExpPerLevelCalculationString", (Object)"{level} * {level} * {level} * 1000");
        config.addDefault("level_useLevelSystem", (Object)"RaC");
        config.addDefault("level_max_level", (Object)-1);
        config.addDefault("custom_level_exp_gain", (Object)"[ZOMBIE=0,SKELETON=0,CREEPER=0]");
        config.addDefault("use_fireworks_on_level_up", (Object)true);
        config.addDefault("use_levelup_message", (Object)true);
        config.addDefault("races_enable", (Object)true);
        config.addDefault("general_armor_disableArmorChecking", (Object)false);
        config.addDefault("disable_health_modifications", (Object)false);
        config.addDefault("race_spawn_when_dead", (Object)false);
        config.addDefault("race_spawn_cooldown", (Object)300);
        config.addDefault("race_spawns_enabled", (Object)true);
        config.addDefault("food_enabled", (Object)true);
        config.addDefault("groups_enabled", (Object)true);
        config.addDefault("groups_system", (Object)"rac");
        config.addDefault("skills_useSkillSystem", (Object)false);
        config.addDefault("skills_skillpointEveryXLevel", (Object)5);
        config.options().copyDefaults(true);
    }

    public GeneralConfig reload() {
        this.plugin.reloadConfig();
        YAMLConfigExtended config = new YAMLConfigExtended(new File(this.plugin.getDataFolder(), "config.yml")).load();
        this.config_channels_enable = config.getBoolean("chat_channel_enable", true);
        this.config_racechat_encrypt = config.getBoolean("chat_race_encryptForOthers", false);
        this.config_disableChatJoinLeaveMessages = config.getBoolean("chat_disable_channel_join_leave_messages", false);
        this.config_whisper_enable = config.getBoolean("chat_whisper_enable", true);
        this.config_defaultHealth = config.getDouble("health_defaultHealth", 20.0);
        this.config_enableDebugOutputs = config.getBoolean("debug_outputs_enable", true);
        this.config_enableErrorUpload = config.getBoolean("debug_outputs_errorUpload", true);
        this.config_alsoUseLeftClickInGuis = config.getBoolean("gui_alsoUseLeftclickInGuis", true);
        this.config_disableAllScoreboardOutputs = config.getBoolean("gui_scoreboard_disableAllOutputs", false);
        this.config_classes_enable = config.getBoolean("classes_enable", true);
        this.config_metrics_enabled = config.getBoolean("metrics_enable", true);
        this.config_useSkillSystem = config.getBoolean("skills_useSkillSystem", false);
        this.config_skillpointEveryXLevel = config.getInt("skills_skillpointEveryXLevel", 5);
        this.config_activate_reminder = config.getBoolean("races_remindDefaultRace_enable", true);
        this.config_reminder_interval = config.getInt("races_remindDefaultRace_interval", 10);
        this.config_adaptListName = config.getBoolean("races_display_adaptListName", true);
        this.config_enable_expDropBonus = config.getBoolean("races_drops_enable", true);
        this.config_usedLanguage = config.getString("language_used", "en");
        this.config_enable_healthbar_in_chat = config.getBoolean("health_bar_inChat_enable", true);
        this.config_usePermissionsForRaces = config.getBoolean("races_permissions_usePermissionsForEachRace", false);
        this.config_usePermissionsForClasses = config.getBoolean("classes_permissions_usePermissionsForEachClasses", false);
        this.config_disableArmorChecking = config.getBoolean("general_armor_disableArmorChecking", false);
        this.config_useRaceClassSelectionMatrix = config.getBoolean("classes_useRaceClassSelectionMatrix", false);
        this.config_classChangeCommandUplink = config.getInt("classes_change_uplinkInSeconds", 0);
        this.config_raceChangeCommandUplink = config.getInt("races_change_uplinkInSeconds", 0);
        this.config_useRaceGUIToSelect = config.getBoolean("races_gui_enable", true);
        this.config_useClassGUIToSelect = config.getBoolean("classes_gui_enable", true);
        this.config_classes_removeClassOnRaceChange = config.getBoolean("classes_removeClassOnRaceChange", false);
        this.config_defaultRaceName = config.getString("races_defaultrace_name", "DefaultRace");
        this.config_defaultRaceTag = config.getString("races_defaultrace_tag", "[NoRace]");
        this.config_takeClassWhenNoClass = config.getString("classes_takeClassWhenNoClass", "");
        this.config_takeRaceWhenNoRace = config.getString("races_takeRaceWhenNoRace", "");
        this.config_enableRaces = config.getBoolean("races_enable", true);
        this.config_gui_level_useMCLevelBar = config.getBoolean("gui_level_useMCLevelBar", false);
        this.config_enable_permanent_scoreboard = config.getBoolean("gui_enable_permanent_scoreboard", false);
        this.config_useFoodManaBar = config.getBoolean("magic_useFoodManaBar", false);
        this.config_races_create_group_for_race = config.getBoolean("races_create_group_for_race", true);
        this.config_food_enabled = config.getBoolean("food_enabled", true);
        this.config_groups_system = config.getString("groups_system", "RaC");
        this.config_mana_use_xp_bar = config.getBoolean("magic_mana_use_xp_bar", false);
        this.config_disabledHotkeySlots.clear();
        this.config_disabledHotkeySlots.addAll(config.getIntegerList("disabled_hotkey_slots"));
        this.config_hotkeysEnabled = config.getBoolean("hotkeys_enabled");
        this.config_useNewTraitBindSystem = config.getBoolean("use_new_traitbind_system", true);
        this.config_use_permissions_for_hotkeys = config.getBoolean("use_permissions_for_hotkeys", false);
        this.config_magic_manaRefillWhileSprinting = config.getBoolean("magic_manaRefillWhileSprinting", false);
        this.config_magic_sprintingManaCost = config.getDouble("magic_sprintingManaCost", 1.5);
        this.config_magic_sprintingManaDrainInterval = config.getInt("magic_sprintingManaDrainInterval", 3);
        this.config_max_level = config.getInt("level_max_level", -1);
        this.config_serializer = config.getString("serialize_serializer_to_use", "yml");
        this.config_preload_data_async = config.getBoolean("serialize_preload_data_async", true);
        this.config_preload_bulk_amount = config.getInt("serialize_preload_bulk_amount", 100000);
        this.config_database_host = config.getString("serialize_database_host", "localhost");
        this.config_database_port = config.getInt("serialize_database_port", 3306);
        this.config_database_db = config.getString("serialize_database_db", "rac");
        this.config_database_username = config.getString("serialize_database_username", "root");
        this.config_database_password = config.getString("serialize_database_password", "password");
        this.config_convert = config.getBoolean("serialize_convert", true);
        this.config_convert_toDB_orFile = config.getBoolean("serialize_convert_to_DB_or_file", false);
        this.config_actionbar_format = config.getString("gui_actionbar_format", "%manabar% &eLvL: %level%  &eExp: %expbar%");
        String config_magic_outOfFightRegeneration_tmp = config.getString("magic_outOfFightRegeneration", "0#100");
        try {
            String[] split = config_magic_outOfFightRegeneration_tmp.split(Pattern.quote("#"));
            double value = Double.parseDouble(split[0]);
            double time = Double.parseDouble(split[1]);
            this.config_magic_outOfFightRegeneration = new Pair<Double, Double>(value, time);
        }
        catch (Throwable exp) {
            this.config_magic_outOfFightRegeneration = new Pair<Double, Double>(0.0, 100.0);
        }
        List<String> list = config.getStringList("disabled_regions");
        this.config_disabled_regions.clear();
        this.config_disabled_regions.addAll(list);
        this.config_itemForMagic = WandItem.generateFrom(config.getString("magic_wandId", "STICK"));
        if (this.config_itemForMagic == null) {
            this.config_itemForMagic = WandItem.generateFrom("STICK");
        }
        this.config_openClassSelectionAfterRaceSelectionWhenNoClass = config.getBoolean("classes_openClassSelectionAfterRaceSelectionWhenNoClass_enable", true);
        this.config_cancleGUIExitWhenNoClassPresent = config.getBoolean("classes_cancleGUIExitWhenNoClassPresent_enable", true);
        this.config_openRaceSelectionOnJoinWhenNoRace = config.getBoolean("races_openRaceSelectionOnJoinWhenNoRace_enable", true);
        this.config_cancleGUIExitWhenNoRacePresent = config.getBoolean("races_cancleGUIExitWhenNoRacePresent_enable", true);
        this.config_debugTimeAfterLoginOpening = config.getInt("races_openRaceSelectionOnJoinWhenNoRace_timeToOpenAfterLoginInSeconds", 2);
        this.config_mapExpPerLevelCalculationString = config.getString("level_mapExpPerLevelCalculationString", "{level} * {level} * {level} * 1000");
        this.config_useLevelSystem = LevelingSystem.parse(config.getString("level_useLevelSystem", "RaC"));
        this.config_keep_max_hp_on_disabled_worlds = config.getBoolean("keep_max_hp_on_disabled_worlds", true);
        this.config_general_disable_commands = config.getStringList("general_disable_commands");
        this.config_disableHealthMods = config.getBoolean("disable_health_modifications", false);
        this.config_useAutoUpdater = config.getBoolean("updater_enableAutoUpdates", false);
        this.config_enableRaceTeams = config.getBoolean("race_teams_enable", false);
        this.config_enableRaceSpawn = config.getBoolean("race_spawns_enabled", true);
        this.config_enableRaceSpawnOnDeath = config.getBoolean("race_spawn_when_dead", true);
        this.config_raceSpawnCooldown = config.getInt("race_spawn_cooldown", 300);
        this.config_general_remove_old_data_days = config.getInt("general_remove_old_data_days", 60);
        this.config_general_remove_old_data_check_empty = config.getBoolean("general_remove_old_data_days", true);
        this.config_useDragonBarForCooldown = config.getBoolean("gui_use_dragon_bar_for_cooldown", false);
        this.config_cooldown_on_wand_message = config.getInt("general_cooldown_on_wand_message", 10);
        this.config_cooldown_on_bow_message = config.getInt("general_cooldown_on_bow_message", 10);
        this.config_general_disable_aliases = config.getStringList("general_disable_aliases");
        this.config_manaManagerType = ManaManagerType.resolve(config.getString("magic_manaManagerType", ManaManagerType.RaC.name()));
        this.config_gui_scoreboard_name = config.getString("gui_scoreboard_name", "&eRaC");
        this.config_use_fireworks_on_level_up = config.getBoolean("use_fireworks_on_level_up", true);
        this.config_use_levelup_message = config.getBoolean("use_levelup_message", true);
        this.config_race_commands_after_change = config.getStringList("races_command_after_change");
        this.config_class_commands_after_change = config.getStringList("classes_command_after_change");
        this.config_npc_select_race.clear();
        this.config_npc_change_race.clear();
        this.config_npc_select_class.clear();
        this.config_npc_change_class.clear();
        this.config_npc_select_race.addAll(config.getStringList("npc_select_race"));
        this.config_npc_change_race.addAll(config.getStringList("npc_change_race"));
        this.config_npc_select_class.addAll(config.getStringList("npc_select_class"));
        this.config_npc_change_class.addAll(config.getStringList("npc_change_class"));
        this.config_hotkeys_material = config.getMaterial("hotkeys_material", Material.SHEARS);
        if (this.config_useLevelSystem == LevelingSystem.RacesAndClasses && !LevelCalculator.verifyGeneratorStringWorks(this.config_mapExpPerLevelCalculationString)) {
            this.plugin.log(" WARNING: The value for the Level Generation String could not be parsed! change: level.mapExpPerLevelCalculationString");
            List<String> wrong = EvalEvaluator.getWrongElements(this.config_mapExpPerLevelCalculationString);
            this.plugin.log(" Unparseable elements of the String are: " + String.join((CharSequence)", ", wrong) + ".");
            this.plugin.log(" Setting the String to ( {level} * {level} * {level} * 1000 ) till fixed.");
            this.config_mapExpPerLevelCalculationString = "{level} * {level} * {level} * 1000";
        }
        if (this.config_useLevelSystem == LevelingSystem.mcMMO && !McMMOLevelManager.verifyGeneratorStringWorks(this.config_mapExpPerLevelCalculationString)) {
            this.plugin.log(" WARNING: The value for the Level Generation String could not be parsed! change: level.mapExpPerLevelCalculationString");
            this.config_mapExpPerLevelCalculationString = "({axes} + {unarmed} + {archery}) / 50";
        }
        List<String> temp_config_worldsDisabled = config.getStringList("worlds_disableOn");
        this.config_worldsDisabled = new LinkedList<String>();
        for (String tempName : temp_config_worldsDisabled) {
            this.config_worldsDisabled.add(tempName.toLowerCase());
        }
        List<String> remaps = config.getStringList("general_command_remaps");
        this.config_command_remaps.clear();
        for (String remap : remaps) {
            if (!remap.contains("->")) continue;
            String[] split = remap.split(Pattern.quote("->"));
            String command = split[0];
            String replace = split[1];
            this.config_command_remaps.put(command, replace);
        }
        this.config_custom_level_exp_gain.clear();
        List<String> temp_config_custom_level_exp = config.getStringList("custom_level_exp_gain");
        for (String temp : temp_config_custom_level_exp) {
            String[] split;
            if (!temp.contains("=") || (split = temp.split(Pattern.quote("="))).length != 2) continue;
            try {
                EntityType type = EntityType.valueOf((String)split[0].toUpperCase());
                int amount = Integer.parseInt(split[1]);
                this.config_custom_level_exp_gain.put(type, amount);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    public RacesAndClasses getPlugin() {
        return this.plugin;
    }

    public boolean isConfig_racechat_encrypt() {
        return this.config_racechat_encrypt;
    }

    public double getConfig_defaultHealth() {
        return this.config_defaultHealth;
    }

    public boolean isConfig_adaptListName() {
        return this.config_adaptListName;
    }

    public boolean isConfig_whisper_enable() {
        return this.config_whisper_enable;
    }

    public boolean isConfig_enableDebugOutputs() {
        return this.config_enableDebugOutputs;
    }

    public boolean isConfig_enableErrorUpload() {
        return this.config_enableErrorUpload;
    }

    public boolean isConfig_classes_enable() {
        return this.config_classes_enable;
    }

    public boolean isConfig_channels_enable() {
        return this.config_channels_enable;
    }

    public boolean isConfig_metrics_enabled() {
        return this.config_metrics_enabled;
    }

    public boolean isConfig_activate_reminder() {
        return this.config_activate_reminder;
    }

    public int getConfig_reminder_interval() {
        return this.config_reminder_interval;
    }

    public boolean isConfig_enable_expDropBonus() {
        return this.config_enable_expDropBonus;
    }

    public boolean isConfig_enable_healthbar_in_chat() {
        return this.config_enable_healthbar_in_chat;
    }

    public boolean isConfig_usePermissionsForRaces() {
        return this.config_usePermissionsForRaces;
    }

    public String getConfig_gui_scoreboard_name() {
        return this.config_gui_scoreboard_name;
    }

    public boolean isConfig_usePermissionsForClasses() {
        return this.config_usePermissionsForClasses;
    }

    public boolean isConfig_useRaceClassSelectionMatrix() {
        return this.config_useRaceClassSelectionMatrix;
    }

    public String getConfig_usedLanguage() {
        return this.config_usedLanguage;
    }

    public List<String> getConfig_worldsDisabled() {
        return this.config_worldsDisabled;
    }

    public int getConfig_raceChangeCommandUplink() {
        return this.config_raceChangeCommandUplink;
    }

    public int getConfig_classChangeCommandUplink() {
        return this.config_classChangeCommandUplink;
    }

    public boolean isConfig_useClassGUIToSelect() {
        return this.config_useClassGUIToSelect;
    }

    public boolean isConfig_useRaceGUIToSelect() {
        return this.config_useRaceGUIToSelect;
    }

    public String getConfig_defaultRaceName() {
        return this.config_defaultRaceName;
    }

    public String getConfig_defaultRaceTag() {
        return this.config_defaultRaceTag;
    }

    public boolean isConfig_enable_permanent_scoreboard() {
        return this.config_enable_permanent_scoreboard;
    }

    public WandItem getConfig_itemForMagic() {
        return this.config_itemForMagic;
    }

    public String getConfig_mapExpPerLevelCalculationString() {
        return this.config_mapExpPerLevelCalculationString;
    }

    public boolean isConfig_openRaceSelectionOnJoinWhenNoRace() {
        return this.config_openRaceSelectionOnJoinWhenNoRace;
    }

    public boolean isConfig_openClassSelectionAfterRaceSelectionWhenNoClass() {
        return this.config_openClassSelectionAfterRaceSelectionWhenNoClass;
    }

    public boolean isConfig_cancleGUIExitWhenNoRacePresent() {
        return this.config_cancleGUIExitWhenNoRacePresent;
    }

    public boolean isConfig_cancleGUIExitWhenNoClassPresent() {
        return this.config_cancleGUIExitWhenNoClassPresent;
    }

    public boolean isConfig_savePlayerDataToDB() {
        if (this.config_savePlayerDataToDB) {
            RacesAndClasses.getPlugin().logWarning("DataBase Support is disabled and will not be enabled in long time, maybe ever.");
            RacesAndClasses.getPlugin().logWarning("Use an older Version to Convert to YML.");
            RacesAndClasses.getPlugin().logWarning("For more details, look at the FAQ on the Bukkit dev page.");
            this.config_savePlayerDataToDB = false;
        }
        return this.config_savePlayerDataToDB;
    }

    public boolean isConfig_useAutoUpdater() {
        return this.config_useAutoUpdater;
    }

    public int getConfig_debugTimeAfterLoginOpening() {
        return this.config_debugTimeAfterLoginOpening;
    }

    public String getConfig_takeClassWhenNoClass() {
        return this.config_takeClassWhenNoClass;
    }

    public String getConfig_takeRaceWhenNoRace() {
        return this.config_takeRaceWhenNoRace;
    }

    public boolean isConfig_alsoUseLeftClickInGuis() {
        return this.config_alsoUseLeftClickInGuis;
    }

    public boolean isConfig_disableAllScoreboardOutputs() {
        return this.config_disableAllScoreboardOutputs;
    }

    public boolean isConfig_enableRaces() {
        return this.config_enableRaces;
    }

    public boolean isConfig_disableArmorChecking() {
        return this.config_disableArmorChecking;
    }

    public boolean isConfig_keep_max_hp_on_disabled_worlds() {
        return this.config_keep_max_hp_on_disabled_worlds;
    }

    public boolean isConfig_disableHealthMods() {
        return this.config_disableHealthMods;
    }

    public List<String> getConfig_general_disable_commands() {
        return this.config_general_disable_commands;
    }

    public boolean isConfig_disableChatJoinLeaveMessages() {
        return this.config_disableChatJoinLeaveMessages;
    }

    public LevelingSystem getConfig_useLevelSystem() {
        return this.config_useLevelSystem;
    }

    public boolean isConfig_enableRaceSpawn() {
        return this.config_enableRaceSpawn;
    }

    public int getConfig_raceSpawnCooldown() {
        return this.config_raceSpawnCooldown;
    }

    public boolean isConfig_enableRaceSpawnOnDeath() {
        return this.config_enableRaceSpawnOnDeath;
    }

    public int getConfig_cooldown_on_bow_message() {
        return this.config_cooldown_on_bow_message;
    }

    public int getConfig_cooldown_on_wand_message() {
        return this.config_cooldown_on_wand_message;
    }

    public List<String> getConfig_general_disable_aliases() {
        return this.config_general_disable_aliases;
    }

    public boolean isConfig_gui_level_useMCLevelBar() {
        return this.config_gui_level_useMCLevelBar;
    }

    public int getConfig_general_remove_old_data_days() {
        return this.config_general_remove_old_data_days;
    }

    public boolean isConfig_general_remove_old_data_check_empty() {
        return this.config_general_remove_old_data_check_empty;
    }

    public boolean isConfig_useFoodManaBar() {
        return this.config_useFoodManaBar;
    }

    public ManaManagerType getConfig_manaManagerType() {
        return this.config_manaManagerType;
    }

    public boolean isConfig_food_enabled() {
        return this.config_food_enabled;
    }

    public Set<String> getConfig_disabledRegions() {
        return this.config_disabled_regions;
    }

    public boolean isConfig_races_create_group_for_race() {
        return this.config_races_create_group_for_race;
    }

    public Set<String> getConfig_npc_select_race() {
        return this.config_npc_select_race;
    }

    public Set<String> getConfig_npc_change_race() {
        return this.config_npc_change_race;
    }

    public Set<String> getConfig_npc_select_class() {
        return this.config_npc_select_class;
    }

    public Set<String> getConfig_npc_change_class() {
        return this.config_npc_change_class;
    }

    public boolean isConfig_hotkeysEnabled() {
        return this.config_hotkeysEnabled;
    }

    public Set<Integer> getConfig_disabledHotkeySlots() {
        return this.config_disabledHotkeySlots;
    }

    public boolean getConfig_enableRaceTeams() {
        return this.config_enableRaceTeams;
    }

    public boolean getConfig_useNewTraitBindSystem() {
        return this.config_useNewTraitBindSystem;
    }

    public Map<EntityType, Integer> getConfig_custom_level_exp_gain() {
        return this.config_custom_level_exp_gain;
    }

    public boolean isConfig_use_fireworks_on_level_up() {
        return this.config_use_fireworks_on_level_up;
    }

    public boolean isConfig_use_levelup_message() {
        return this.config_use_levelup_message;
    }

    public Pair<Double, Double> getConfig_magic_outOfFightRegeneration() {
        return this.config_magic_outOfFightRegeneration;
    }

    public double getConfig_magic_sprintingManaCost() {
        return this.config_magic_sprintingManaCost;
    }

    public int getConfig_magic_sprintingManaDrainInterval() {
        return this.config_magic_sprintingManaDrainInterval;
    }

    public boolean getConfig_magic_manaRefillWhileSprinting() {
        return this.config_magic_manaRefillWhileSprinting;
    }

    public Material getConfig_hotkeys_material() {
        return this.config_hotkeys_material;
    }

    public int getConfig_max_level() {
        return this.config_max_level;
    }

    public List<String> getConfig_race_commands_after_change() {
        return this.config_race_commands_after_change;
    }

    public List<String> getConfig_class_commands_after_change() {
        return this.config_class_commands_after_change;
    }

    public Map<String, String> getConfig_command_remaps() {
        return this.config_command_remaps;
    }

    public boolean isConfig_useSkillSystem() {
        return this.config_useSkillSystem;
    }

    public int getConfig_skillpointEveryXLevel() {
        return this.config_skillpointEveryXLevel;
    }

    public boolean isConfig_classes_removeClassOnRaceChange() {
        return this.config_classes_removeClassOnRaceChange;
    }

    public boolean isConfig_groups_enable() {
        return this.config_groups_enable;
    }

    public String getConfig_groups_system() {
        return this.config_groups_system;
    }

    public String getConfig_serializer() {
        return this.config_serializer;
    }

    public SQL.SQLProperties getConfig_databaseData() {
        SQL.SQLProperties props = new SQL.SQLProperties();
        props.serverName = this.config_database_host;
        props.serverPort = String.valueOf(this.config_database_port);
        props.serverDB = this.config_database_db;
        props.userName = this.config_database_username;
        props.password = this.config_database_password;
        return props;
    }

    public boolean isConfig_preload_data_async() {
        return this.config_preload_data_async;
    }

    public int getConfig_preload_bulk_amount() {
        return this.config_preload_bulk_amount;
    }

    public String getConfig_actionbar_format() {
        return this.config_actionbar_format;
    }

    public boolean isConfig_mana_use_xp_bar() {
        return this.config_mana_use_xp_bar;
    }

    public boolean isConfig_convert() {
        return this.config_convert;
    }

    public boolean isConfig_convert_toDB_orFile() {
        return this.config_convert_toDB_orFile;
    }

    public boolean isConfig_use_permissions_for_hotkeys() {
        return this.config_use_permissions_for_hotkeys;
    }

    public boolean isConfig_useDragonBarForCooldown() {
        return this.config_useDragonBarForCooldown;
    }
}

