/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration.global;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.io.IOException;

public class ChannelConfig {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private YAMLConfigExtended config;
    private String config_channel_default_color;
    private String config_channel_default_format;
    private String config_racechat_default_color;
    private String config_racechat_default_format;
    private String config_worldchat_default_color;
    private String config_worldchat_default_format;
    private String config_globalchat_default_color;
    private String config_globalchat_default_format;
    private String config_localchat_default_color;
    private String config_localchat_default_format;
    private int config_localchat_range;
    private String config_playerJoinMessage;
    private String config_playerLeaveMessage;

    public ChannelConfig() {
        this.initStructure();
        this.setupConfiguration();
    }

    private void initStructure() {
        File configFile;
        File configPath = new File(Consts.channelConfigPathYML);
        if (!configPath.exists()) {
            configPath.mkdirs();
        }
        if (!(configFile = new File(Consts.channelConfigYML)).exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException exception) {
                this.plugin.log("Counld not create File: " + configFile.toString());
                return;
            }
        }
        this.config = new YAMLConfigExtended(Consts.channelConfigYML);
    }

    private void setupConfiguration() {
        this.config.load();
        this.config.addDefault("chat.channel.default.color", "&2");
        this.config.addDefault("chat.channel.default.format", "{color}[{nick}] &f{prefix}{sender}{suffix}{color}: {msg}");
        this.config.addDefault("chat.channel.race.default.color", "&3");
        this.config.addDefault("chat.channel.race.default.format", "{color}[{nick}] &f{prefix}{sender}{suffix}{color}: {msg}");
        this.config.addDefault("chat.channel.world.default.color", "&4");
        this.config.addDefault("chat.channel.world.default.format", "{color}[{nick}] &f{prefix}{sender}{suffix}{color}: {msg}");
        this.config.addDefault("chat.channel.global.default.color", "&5");
        this.config.addDefault("chat.channel.global.default.format", "{color}[{nick}] &f{prefix}{sender}{suffix}{color}: {msg}");
        this.config.addDefault("chat.channel.local.default.color", "&f");
        this.config.addDefault("chat.channel.local.default.format", "{color}[Local] &f{prefix}{sender}{suffix}{color}: {msg}");
        this.config.addDefault("chat.channel.local.range", 100);
        this.config.addDefault("chat.channel.format.join", "{color}[{nick}] Player: &f[{sender}] {color}has joined the Channel.");
        this.config.addDefault("chat.channel.format.leave", "{color}[{nick}] Player: &f[{sender}] {color} has left the Channel.");
        this.config.options().copyDefaults(true);
        this.config.forceSave();
    }

    public void reload() {
        this.config.load();
        this.config_channel_default_color = this.config.getString("chat.channel.default.color", "&2");
        this.config_channel_default_format = this.config.getString("chat.channel.default.format", "{color}[{nick}] &f{prefix}{race}{sender}{suffix}{color}: {msg}");
        this.config_racechat_default_color = this.config.getString("chat.channel.race.default.color", "&3");
        this.config_racechat_default_format = this.config.getString("chat.channel.race.default.format", "{color}[{nick}] &f{prefix}{race}{sender}{suffix}{color}: {msg}");
        this.config_worldchat_default_color = this.config.getString("chat.channel.world.default.color", "&4");
        this.config_worldchat_default_format = this.config.getString("chat.channel.world.default.format", "{color}[{nick}] &f{prefix}{race}{sender}{suffix}{color}: {msg}");
        this.config_globalchat_default_color = this.config.getString("chat.channel.global.default.color", "&5");
        this.config_globalchat_default_format = this.config.getString("chat.channel.global.default.format", "{color}[{nick}] &f{prefix}{race}{sender}{suffix}{color}: {msg}");
        this.config_localchat_default_color = this.config.getString("chat.channel.local.default.color", "&f");
        this.config_localchat_default_format = this.config.getString("chat.channel.local.default.format", "{color}[Local] &f{prefix}{race}{sender}{suffix}{color}: {msg}");
        this.config_localchat_range = this.config.getInt("chat.channel.local.range", 100);
        this.config_playerJoinMessage = this.config.getString("chat.channel.format.join", "{color}[{nick}] Player: [{sender}] {color} has joined the Channel.");
        this.config_playerLeaveMessage = this.config.getString("chat.channel.format.leave", "{color}[{nick}] Player: [{sender}] {color} has left the Channel.");
    }

    public String getConfig_channel_default_color() {
        return this.config_channel_default_color;
    }

    public String getConfig_channel_default_format() {
        return this.config_channel_default_format;
    }

    public String getConfig_racechat_default_color() {
        return this.config_racechat_default_color;
    }

    public String getConfig_racechat_default_format() {
        return this.config_racechat_default_format;
    }

    public String getConfig_worldchat_default_color() {
        return this.config_worldchat_default_color;
    }

    public String getConfig_worldchat_default_format() {
        return this.config_worldchat_default_format;
    }

    public String getConfig_globalchat_default_color() {
        return this.config_globalchat_default_color;
    }

    public String getConfig_globalchat_default_format() {
        return this.config_globalchat_default_format;
    }

    public String getConfig_localchat_default_color() {
        return this.config_localchat_default_color;
    }

    public String getConfig_localchat_default_format() {
        return this.config_localchat_default_format;
    }

    public int getConfig_localchat_range() {
        return this.config_localchat_range;
    }

    public String getConfig_PlayerJoinFormat() {
        return this.config_playerJoinMessage;
    }

    public String getConfig_PlayerLeaveFormat() {
        return this.config_playerLeaveMessage;
    }
}

