/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration.armory;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;

public class ArmorConfig {
    private final File defaultFile = new File(RacesAndClasses.getPlugin().getDataFolder(), "armor.yml");
    private final YAMLConfigExtended config = new YAMLConfigExtended(this.defaultFile);

    public ArmorConfig() {
        if (!this.defaultFile.exists()) {
            this.createDefaultFile();
        }
        this.reload();
    }

    private void createDefaultFile() {
        this.config.clearConfig();
        HashSet<Material> materials = new HashSet<Material>();
        materials.clear();
        materials.add(Material.LEATHER_BOOTS);
        materials.add(Material.LEATHER_LEGGINGS);
        materials.add(Material.LEATHER_CHESTPLATE);
        materials.add(Material.LEATHER_HELMET);
        this.config.addDefault("leather", this.toStringList(materials));
        materials.clear();
        materials.add(Material.IRON_BOOTS);
        materials.add(Material.IRON_LEGGINGS);
        materials.add(Material.IRON_CHESTPLATE);
        materials.add(Material.IRON_HELMET);
        this.config.addDefault("iron", this.toStringList(materials));
        materials.clear();
        materials.add(Material.CHAINMAIL_BOOTS);
        materials.add(Material.CHAINMAIL_LEGGINGS);
        materials.add(Material.CHAINMAIL_CHESTPLATE);
        materials.add(Material.CHAINMAIL_HELMET);
        this.config.addDefault("chain", this.toStringList(materials));
        materials.clear();
        materials.add(Material.GOLD_BOOTS);
        materials.add(Material.GOLD_LEGGINGS);
        materials.add(Material.GOLD_CHESTPLATE);
        materials.add(Material.GOLD_HELMET);
        this.config.addDefault("gold", this.toStringList(materials));
        materials.clear();
        materials.add(Material.DIAMOND_BOOTS);
        materials.add(Material.DIAMOND_LEGGINGS);
        materials.add(Material.DIAMOND_CHESTPLATE);
        materials.add(Material.DIAMOND_HELMET);
        this.config.addDefault("diamond", this.toStringList(materials));
        this.config.options().copyDefaults(true);
        this.config.save();
    }

    private List<String> toStringList(Collection<Material> mats) {
        LinkedList<String> names = new LinkedList<String>();
        for (Material mat : mats) {
            names.add(mat.name());
        }
        return names;
    }

    public void reload() {
        this.config.load();
        HashMap<String, Set<Material>> toSet = new HashMap<String, Set<Material>>();
        for (String node : this.config.getRootChildren()) {
            HashSet<Material> parsed = new HashSet<Material>();
            this.parseMaterials(parsed, this.config.getStringList(node));
            if (parsed.isEmpty()) continue;
            toSet.put(node, parsed);
        }
        ItemUtils.ItemQuality.loadDefault();
        if (!toSet.isEmpty()) {
            ItemUtils.ItemQuality.set(toSet);
        }
    }

    private void parseMaterials(Collection<Material> collection, Collection<String> toAdd) {
        collection.clear();
        for (String key : toAdd) {
            this.addMaterial(collection, key);
        }
    }

    private void addMaterial(Collection<Material> collection, String mat) {
        try {
            Material realMat = Material.matchMaterial((String)mat);
            if (realMat != null) {
                collection.add(realMat);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

