/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.configuration;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.global.GeneralConfigText;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConfigTemplate {
    private RacesAndClasses plugin;
    private File configFile;
    private Map<String, String> replacements = new HashMap<String, String>();

    public ConfigTemplate() {
        this.fillReplacements();
        this.plugin = RacesAndClasses.getPlugin();
        File pluginFolder = new File(this.plugin.getDataFolder().toString());
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        this.configFile = new File(this.plugin.getDataFolder() + File.separator + "config.yml");
    }

    public boolean isOldConfigVersion() {
        if (!this.configFile.exists()) {
            return true;
        }
        boolean isOldVersion = true;
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
            while ((currentLine = reader.readLine()) != null) {
                if (!currentLine.contains("#TemplateVersion ")) continue;
                if (!(currentLine = currentLine.replace("#TemplateVersion ", "")).equalsIgnoreCase("24")) break;
                isOldVersion = false;
                break;
            }
            reader.close();
        }
        catch (Exception e) {
            this.plugin.log("Could not get Version");
        }
        return isOldVersion;
    }

    private String modifyLine(String line) {
        Object obj;
        String node;
        if (line.length() == 0) {
            return line;
        }
        if (line.contains("#")) {
            return line;
        }
        if (!line.contains(":")) {
            return line;
        }
        String[] nodes = line.split(":");
        String nodeToCheck = node = nodes[0];
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String key = entry.getKey();
            String replacement = entry.getValue();
            if (!nodeToCheck.equals(replacement) || !this.plugin.getConfig().contains(nodeToCheck)) continue;
            nodeToCheck = key;
        }
        Object object = obj = this.plugin.getConfig().contains(nodeToCheck.replace("_", ".")) ? this.plugin.getConfig().get(nodeToCheck.replace("_", ".")) : this.plugin.getConfig().get(nodeToCheck);
        if (obj == null) {
            return line;
        }
        String stringAdditions = "";
        if (obj instanceof String) {
            stringAdditions = "'";
        }
        return String.valueOf(node) + ": " + stringAdditions + obj.toString() + stringAdditions;
    }

    public void writeTemplate() {
        if (this.configFile.exists()) {
            this.configFile.delete();
        }
        try {
            this.configFile.createNewFile();
        }
        catch (IOException e) {
            this.plugin.log("Could not create new ConfigTotal File.");
            e.printStackTrace();
        }
        String content = GeneralConfigText.GlobalConfigText();
        String[] lines = content.split("\n");
        content = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            content = String.valueOf(content) + this.modifyLine(line) + System.getProperty("line.separator");
            ++n2;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.configFile));
            out.write(content);
            out.close();
        }
        catch (IOException e) {
            this.plugin.log("Error on replacing the ConfigTotal File");
            e.printStackTrace();
        }
    }

    private void fillReplacements() {
        this.replacements.put("gui_useFoodManaBar", "magic_useFoodManaBar");
        this.replacements.put("gui_manaManagerType", "magic_manaManagerType");
    }
}

