/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.statistics;

import de.tobiyas.racesandclasses.APIs.StatisticAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.statistics.StartupStatisticCategory;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandExecutor_Statistics
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_Statistics() {
        super("racstatistics", "racs");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.statistics")) {
            return true;
        }
        if (args.length > 0) {
            String traitName = "";
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                traitName = String.valueOf(traitName) + arg + " ";
                ++n2;
            }
            traitName = traitName.trim();
            this.showStatisticToTrait(sender, traitName);
        } else {
            this.sendHelp(sender);
        }
        return true;
    }

    private void showStatisticToTrait(CommandSender sender, String traitName) {
        if (traitName.equalsIgnoreCase("total")) {
            this.showOverallStatistics(sender);
            return;
        }
        if (traitName.equalsIgnoreCase("startup")) {
            this.showStartupStatistics(sender);
            return;
        }
        if (traitName.equalsIgnoreCase("loadedplayers")) {
            this.showLoadedPlayers(sender);
            return;
        }
        sender.sendMessage(ChatColor.YELLOW + "==== " + ChatColor.AQUA + "Statistics to: " + ChatColor.LIGHT_PURPLE + traitName + ChatColor.YELLOW + " ====");
        long totalEvents = StatisticAPI.getTotalTriggersOfTrait(traitName);
        if (totalEvents < 0L) {
            sender.sendMessage(ChatColor.RED + "The Trait: " + ChatColor.LIGHT_PURPLE + traitName + ChatColor.RED + " does not exist.");
            return;
        }
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Total events on Trait " + ChatColor.DARK_PURPLE + traitName + ChatColor.LIGHT_PURPLE + ": " + ChatColor.AQUA + totalEvents);
        double eventsPerMin = StatisticAPI.getTotalTriggersOfTraitPerMinute(traitName);
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Events / Minute on Trait " + ChatColor.DARK_PURPLE + traitName + ChatColor.LIGHT_PURPLE + ": " + ChatColor.AQUA + eventsPerMin);
        long timeUsedForTrait = StatisticAPI.getTraitsUsedTime(traitName);
        String formated = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(timeUsedForTrait), TimeUnit.MILLISECONDS.toSeconds(timeUsedForTrait) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(timeUsedForTrait)));
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Time used for Trait: " + ChatColor.AQUA + formated);
    }

    private void showLoadedPlayers(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "Loaded Players: " + this.plugin.getPlayerManager().getPlayerNumber());
    }

    private void showStartupStatistics(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "===== STARTUP =====");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Timings are in: " + ChatColor.LIGHT_PURPLE + "Millisecond");
        StartupStatisticCategory[] startupStatisticCategoryArray = StartupStatisticCategory.values();
        int n = startupStatisticCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            StartupStatisticCategory category = startupStatisticCategoryArray[n2];
            sender.sendMessage(ChatColor.GREEN + category.name() + ": " + ChatColor.LIGHT_PURPLE + category.timeInMiliSeconds);
            ++n2;
        }
    }

    private void showOverallStatistics(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "==== " + ChatColor.AQUA + "Overall Statistics " + ChatColor.YELLOW + " ====");
        String timeRunning = StatisticAPI.getTimeRunning();
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Time running: " + ChatColor.AQUA + timeRunning);
        long totalEvents = StatisticAPI.getEventsTriggeredTotal();
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Total events: " + ChatColor.AQUA + totalEvents);
        double eventsPerMin = StatisticAPI.getEventsTotalPerMinute();
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Events / Minute: " + ChatColor.AQUA + eventsPerMin);
        long totalTimeUsed = StatisticAPI.getTotalTraitsUsedTime();
        String formated = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(totalTimeUsed), TimeUnit.MILLISECONDS.toSeconds(totalTimeUsed) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(totalTimeUsed)));
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "Time used in Total: " + ChatColor.AQUA + formated);
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "[RaC]" + ChatColor.RED + " Use this command as following: " + ChatColor.LIGHT_PURPLE + "/racstatistics <traitname>");
        sender.sendMessage(ChatColor.YELLOW + "[RAC]" + ChatColor.RED + " Use " + ChatColor.LIGHT_PURPLE + "/racestatistics total" + ChatColor.RED + " to see the total statistics.");
        sender.sendMessage(ChatColor.YELLOW + "[RAC]" + ChatColor.RED + " Use " + ChatColor.LIGHT_PURPLE + "/racestatistics startup" + ChatColor.RED + " to see startup statistics.");
    }
}

