/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.skilltree;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui.SkillTreeGui;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;

public class CommandExecutor_SkillTree
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_SkillTree() {
        super("skilltree", "skt");
        this.description = "Opens the SkillTree GUI";
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 2 && args[0].equals("clear") && sender.hasPermission("RaC.skilltree.clear")) {
            RaCPlayer player = RaCPlayerManager.get().getPlayerByName(args[1]);
            if (player == null) {
                LanguageAPI.sendTranslatedMessage(sender, "player_not_exist", "player", args[1]);
                return true;
            }
            player.getSkillTreeManager().clearSkills();
            player.getSpellManager().rescan();
            player.getArrowManager().rescanPlayer();
            sender.sendMessage(ChatColor.GREEN + "Cleared.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(LanguageAPI.translateIgnoreError("only_players").build());
            return true;
        }
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_useSkillSystem()) {
            LanguageAPI.sendTranslatedMessage(sender, "something_disabled", "value", "SkillTree");
            return true;
        }
        Player player = (Player)sender;
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        Set<Trait> traits = TraitHolderCombinder.getAllTraitsOfPlayer(racPlayer);
        boolean hasAnySkillable = false;
        for (Trait trait : traits) {
            if (trait.isPermanentSkill() || !trait.isVisible() || trait.getSkillPointCost(1) <= 0) continue;
            hasAnySkillable = true;
        }
        if (hasAnySkillable) {
            player.openInventory((InventoryView)new SkillTreeGui(player));
        } else {
            LanguageAPI.sendTranslatedMessage(sender, "no_traits");
        }
        return true;
    }
}

