/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.reflect;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.CommandInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CommandMap {
    public static SimpleCommandMap get() {
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            return (SimpleCommandMap)field.get(Bukkit.getServer());
        }
        catch (Throwable exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static void registerCommands(List<CommandInterface> commands, RacesAndClasses racesAndClasses) {
        SimpleCommandMap map = CommandMap.get();
        if (map != null) {
            LinkedList<PluginCommand> toRegister = new LinkedList<PluginCommand>();
            for (CommandInterface command : commands) {
                Collection<PluginCommand> commandWrapper = CommandMap.generate(command.getCommandNames(), (Plugin)racesAndClasses);
                if (commandWrapper == null || commandWrapper.isEmpty()) continue;
                for (PluginCommand subCommand : commandWrapper) {
                    subCommand.setAliases(Arrays.asList(command.getAliases()));
                    subCommand.setDescription(command.getDescription());
                    subCommand.setTabCompleter((TabCompleter)command);
                    subCommand.setExecutor((CommandExecutor)command);
                    toRegister.add(subCommand);
                }
            }
            map.registerAll(racesAndClasses.getDescription().getName(), toRegister);
        }
    }

    private static Collection<PluginCommand> generate(Collection<String> names, Plugin plugin) {
        HashSet<PluginCommand> commands = new HashSet<PluginCommand>();
        for (String name : names) {
            try {
                Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                constructor.setAccessible(true);
                PluginCommand command = (PluginCommand)constructor.newInstance(name, plugin);
                if (command == null) continue;
                commands.add(command);
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
        }
        return commands;
    }
}

