/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.racespawn;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.RaceAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.autocomplete.AutoCompleteUtils;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor_RaceSpawn
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_RaceSpawn() {
        super("racespawn");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enableRaceSpawn()) {
            LanguageAPI.sendTranslatedMessage(sender, "something_disabled", "value", "Race-Spawns");
            return true;
        }
        if (sender == Bukkit.getConsoleSender() && args.length >= 1) {
            Player player = PlayerUtils.getPlayer(args[0]);
            if (player == null) {
                return true;
            }
            Location spawn = RaceAPI.getRaceSpawnOfPlayer(player);
            if (spawn == null) {
                return true;
            }
            player.teleport(spawn);
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.racespawn.use.own")) {
                return true;
            }
            if (this.checkCooldown(player)) {
                return true;
            }
            this.sendPlayerToOwnSpawn(player);
            return true;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set")) {
                if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.racespawn.create")) {
                    return true;
                }
                String race = args[1];
                RaceContainer container = RaceAPI.getRaceByName(race);
                if (container == null) {
                    LanguageAPI.sendTranslatedMessage(sender, "race_not_exist", "race", race);
                    return true;
                }
                this.plugin.getAddinManager().getRaceSpawnManager().setRaceSpawn(race, player.getLocation());
                LanguageAPI.sendTranslatedMessage(sender, "race_spawn_created", "race", container.getDisplayName());
                return true;
            }
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "wrong_command_use", "command", "/racespawn set <racename>");
            return true;
        }
        if (args.length == 1) {
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
            RaceContainer holder = racPlayer.getRace();
            String own = holder.getDisplayName();
            String wanted = args[0];
            if (this.checkCooldown(player)) {
                return true;
            }
            if (own.equalsIgnoreCase(wanted)) {
                if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.racespawn.use.own")) {
                    return true;
                }
                this.sendPlayerToOwnSpawn(player);
                return true;
            }
            if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.racespawn.use.other")) {
                return true;
            }
            this.sendPlayerToSpawn(player, wanted);
            return true;
        }
        return true;
    }

    private boolean checkCooldown(Player player) {
        int cooldown = this.plugin.getCooldownManager().stillHasCooldown(player.getName(), "command.racespawn");
        if (cooldown > 0) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "cooldown_is_ready_in", "time", String.valueOf(cooldown) + " Seconds");
            return true;
        }
        return false;
    }

    private boolean sendPlayerToSpawn(Player player, String spawn) {
        Location loc = this.plugin.getAddinManager().getRaceSpawnManager().getSpawnForRace(spawn);
        if (loc == null) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "race_spawn_no_spawnpoint", "race", spawn);
            return false;
        }
        player.teleport(loc);
        int cooldownTime = this.plugin.getConfigManager().getGeneralConfig().getConfig_raceSpawnCooldown();
        this.plugin.getCooldownManager().setCooldown(player.getName(), "command.racespawn", cooldownTime);
        LanguageAPI.sendTranslatedMessage((CommandSender)player, "race_spawn_teleport_success", "race", spawn);
        return false;
    }

    private boolean sendPlayerToOwnSpawn(Player player) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        RaceContainer holder = racPlayer.getRace();
        if (holder == null) {
            return false;
        }
        return this.sendPlayerToSpawn(player, holder.getDisplayName());
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String raceStart = null;
        List<String> raceNames = RaceAPI.getAllRaceNames();
        if (args.length == 1) {
            raceStart = args[0];
            raceNames.add("set");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            raceStart = args[1];
        }
        if (raceStart != null) {
            return AutoCompleteUtils.getAllNamesWith(raceNames, raceStart);
        }
        return super.onTabComplete(sender, command, alias, args);
    }
}

