/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.pets;

import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.pets.Pet;
import de.tobiyas.racesandclasses.pets.PetBuilder;
import de.tobiyas.racesandclasses.pets.PlayerPetManager;
import de.tobiyas.racesandclasses.pets.SpawnedPet;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class Command_RaCPet
extends AbstractCommand {
    public Command_RaCPet() {
        super("racpet");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only as Player.");
            return true;
        }
        if (sender.isOp() && args.length == 1 && args[0].equalsIgnoreCase("test")) {
            Player player = (Player)sender;
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
            Pet pet = new PetBuilder().setPetType(EntityType.ZOMBIE).build();
            racPlayer.getPlayerPetManager().registerNewPet(pet);
            player.sendMessage("Done");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
            Player player = (Player)sender;
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
            PlayerPetManager petManager = racPlayer.getPlayerPetManager();
            player.sendMessage(ChatColor.GREEN + "Pets:");
            for (SpawnedPet pet : petManager.getSpawnedPets()) {
                player.sendMessage(ChatColor.AQUA + pet.getPet().getPetName() + " - Dead: " + pet.getPetEntity().isDead());
            }
            if (petManager.getRegisteredPets().isEmpty()) {
                player.sendMessage(ChatColor.RED + "Keine");
            }
            return true;
        }
        if (sender.isOp() && args.length == 1 && args[0].equalsIgnoreCase("cleanpet")) {
            Player player = (Player)sender;
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
            racPlayer.getPlayerPetManager().despawnAndClear();
            player.sendMessage("Done");
            return true;
        }
        this.pasteHelp(sender);
        return true;
    }

    private void pasteHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "=== RAC Pets ===");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "/racpet list" + ChatColor.YELLOW + "  Adds / Removes EXP to player.");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "/raclevel <player> lvl <value>" + ChatColor.YELLOW + "  Adds / Removes LEVELS to player.");
    }
}

