/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.level;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelCalculator;
import de.tobiyas.racesandclasses.playermanagement.leveling.LevelPackage;
import de.tobiyas.racesandclasses.playermanagement.leveling.PlayerLevelManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Command_RACLevel
extends AbstractCommand {
    public Command_RACLevel() {
        super("raclevel", "lvl");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && (!RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent(sender, "RaC.level.edit") || args.length == 0)) {
            this.postLevel((Player)sender);
            return true;
        }
        if (args.length != 3) {
            this.pasteHelp(sender);
            return true;
        }
        String subCommand = args[1];
        RaCPlayer player = RaCPlayerManager.get().getPlayerByName(args[0]);
        if (player == null) {
            LanguageAPI.sendTranslatedMessage(sender, "player_not_exist", "PLAYER", args[0]);
            return true;
        }
        int value = 0;
        try {
            value = Integer.valueOf(args[2]);
        }
        catch (NumberFormatException exp) {
            LanguageAPI.sendTranslatedMessage(sender, "number_not_readable");
            return true;
        }
        PlayerLevelManager manager = player.getLevelManager();
        if (manager == null) {
            LanguageAPI.sendTranslatedMessage(sender, "player_not_exist", "player", player.getName());
            return true;
        }
        if (value == 0) {
            LanguageAPI.sendTranslatedMessage(sender, "value_0_not_allowed", "player", player.getName());
            return true;
        }
        if ("exp".equalsIgnoreCase(subCommand)) {
            if (value < 0) {
                manager.removeExp(-value);
            }
            if (value > 0) {
                manager.addExp(value);
            }
            LanguageAPI.sendTranslatedMessage(sender, "success");
            return true;
        }
        if ("lvl".equalsIgnoreCase(subCommand)) {
            if (value > 0) {
                manager.addLevel(value);
            } else {
                manager.removeLevel(-value);
            }
            LanguageAPI.sendTranslatedMessage(sender, "success");
            return true;
        }
        this.pasteHelp(sender);
        return true;
    }

    private void postLevel(Player player) {
        RaCPlayer pl = RaCPlayerManager.get().getPlayer(player);
        int level = LevelAPI.getCurrentLevel(player);
        int levelExp = LevelAPI.getCurrentExpOfLevel(player);
        LevelPackage levelPack = LevelCalculator.calculateLevelPackage(level);
        int maxEXP = levelPack.getMaxEXP();
        pl.sendMessage(ChatColor.YELLOW + "==== Level ====");
        pl.sendMessage(ChatColor.YELLOW + "Level: " + ChatColor.AQUA + level);
        pl.sendMessage(ChatColor.YELLOW + "Exp: " + ChatColor.AQUA + levelExp + ChatColor.GRAY + "/" + ChatColor.AQUA + maxEXP);
    }

    private void pasteHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "=== RAC Level ===");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "/raclevel <player> exp <value>" + ChatColor.YELLOW + "  Adds / Removes EXP to player.");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "/raclevel <player> lvl <value>" + ChatColor.YELLOW + "  Adds / Removes LEVELS to player.");
    }
}

