/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.help;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor_PermissionCheck
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_PermissionCheck() {
        super("racpermcheck", "rc", "racp");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && "race".equalsIgnoreCase(args[0])) {
            this.listRacePermissions(sender);
            return true;
        }
        if (args.length == 1 && "class".equalsIgnoreCase(args[0])) {
            this.listClassPermissions(sender);
            return true;
        }
        if (args.length == 1 && "class".equalsIgnoreCase(args[0])) {
            this.listCommandPermissions(sender);
            return true;
        }
        return true;
    }

    private void listRacePermissions(CommandSender sender) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enableRaces()) {
            sender.sendMessage("[RaC] Races are Disabled.");
            return;
        }
        sender.sendMessage(ChatColor.RED + "=====" + ChatColor.YELLOW + " Race Permissions: " + ChatColor.RED + "=====");
        List<String> holders = this.plugin.getRaceManager().listAllVisibleHolders();
        for (String holderName : holders) {
            AbstractTraitHolder holder = this.plugin.getRaceManager().getHolderByName(holderName);
            boolean senderContained = sender instanceof Player ? holder.containsPlayer(RaCPlayerManager.get().getPlayer((Player)sender)) : false;
            boolean hasPermissions = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.races." + holderName);
            sender.sendMessage(ChatColor.BLUE + holder.getDisplayName() + ": " + (senderContained ? ChatColor.LIGHT_PURPLE + " (Your Race)" : (hasPermissions ? ChatColor.GREEN + " Permissions" : ChatColor.RED + " No Permissions")));
        }
        if (holders.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You have access to no Race.");
        }
    }

    private void listClassPermissions(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "=====" + ChatColor.YELLOW + " Class Permissions: " + ChatColor.RED + "=====");
        List<String> holders = this.plugin.getClassManager().listAllVisibleHolders();
        for (String holderName : holders) {
            AbstractTraitHolder holder = this.plugin.getClassManager().getHolderByName(holderName);
            boolean senderContained = sender instanceof Player ? holder.containsPlayer(RaCPlayerManager.get().getPlayer((Player)sender)) : false;
            boolean hasPermissions = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.classes." + holderName);
            sender.sendMessage(ChatColor.BLUE + holder.getDisplayName() + ": " + (senderContained ? ChatColor.LIGHT_PURPLE + " (Your Class)" : (hasPermissions ? ChatColor.GREEN + " Permissions" : ChatColor.RED + " No Permissions")));
        }
        if (holders.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You have access to no Class.");
        }
    }

    private void listCommandPermissions(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "=====" + ChatColor.YELLOW + " Command Permissions: " + ChatColor.RED + "=====");
        boolean raceSelectPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.race.select");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/race select' " + (raceSelectPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean raceChangePermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.race.change");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/race change' " + (raceChangePermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean classSelectPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.class.select");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/class select' " + (classSelectPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean classChangePermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.class.change");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/class change' " + (classChangePermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean healSelfPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.heal.self");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/racesheal' " + (healSelfPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean healOthersPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.heal.other");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/raceheal <playername>' " + (healOthersPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean setGodmodePermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.god");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/racesgod [playername]' " + (setGodmodePermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean reloadPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.reload");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/racesreload [-gc]' " + (reloadPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean debugPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.debug");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/racesdebug [subcommand]' " + (debugPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
        boolean statisticsPermission = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.debug");
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "'/racesstatistics [plugin / subcommand]' " + (statisticsPermission ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
    }
}

