/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.health;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor_RaceHeal
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_RaceHeal() {
        super("raceheal", "rh", "rheal");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.healSelf(sender);
            return true;
        }
        if (args.length == 1) {
            String otherName = args[0];
            this.healOther(sender, otherName);
            return true;
        }
        LanguageAPI.sendTranslatedMessage(sender, "wrong_command_use", "command", "/raceheal [PlayerName]");
        return true;
    }

    private void healSelf(CommandSender sender) {
        if (this.plugin.getPermissionManager().checkPermissions(sender, "RaC.heal.self")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
                double maxHealth = CompatibilityModifier.BukkitPlayer.safeGetMaxHealth(player);
                CompatibilityModifier.BukkitPlayer.safeSetHealth(maxHealth, player);
                racPlayer.getManaManager().fillMana(10000.0);
                LanguageAPI.sendTranslatedMessage(sender, "healed");
            } else {
                LanguageAPI.sendTranslatedMessage(sender, "only_players");
            }
        }
    }

    private void healOther(CommandSender sender, String otherName) {
        if (this.plugin.getPermissionManager().checkPermissions(sender, "RaC.heal.other")) {
            RaCPlayer otherRaCPlayer = RaCPlayerManager.get().getPlayerByName(otherName);
            if (otherRaCPlayer != null && otherRaCPlayer.isOnline()) {
                Player player = (Player)sender;
                double maxHealth = CompatibilityModifier.BukkitPlayer.safeGetMaxHealth(otherRaCPlayer.getPlayer());
                CompatibilityModifier.BukkitPlayer.safeSetHealth(maxHealth, otherRaCPlayer.getPlayer());
                otherRaCPlayer.getManaManager().fillMana(10000.0);
                LanguageAPI.sendTranslatedMessage(sender, "healed_other", "player", otherRaCPlayer.getName());
                LanguageAPI.sendTranslatedMessage(otherRaCPlayer, "healed_by", "player", player.getName());
            } else {
                LanguageAPI.sendTranslatedMessage(sender, "player_not_exist", "player", otherName);
            }
        }
    }
}

