/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.general;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.playermanagement.health.HealthManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaManager;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandExecutor_PlayerInfo
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_PlayerInfo() {
        super("playerinfo");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        RaCPlayer racPlayer;
        if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.playerinfos.command")) {
            return true;
        }
        Player player = null;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + LanguageAPI.translateIgnoreError("needs_1_arg").replace("command", "/playerinfo <playername>").build());
                return true;
            }
            player = (Player)sender;
        } else {
            racPlayer = RaCPlayerManager.get().getPlayerByName(args[0]);
            Player player2 = player = racPlayer == null ? null : racPlayer.getPlayer();
        }
        if (player == null) {
            sender.sendMessage(ChatColor.RED + LanguageAPI.translateIgnoreError("player_not_exist").replace("player", args[0]).build());
            return true;
        }
        racPlayer = RaCPlayerManager.get().getPlayer(player);
        RaceContainer raceContainer = racPlayer.getRace();
        ClassContainer classContainer = racPlayer.getclass();
        String className = "None";
        String raceName = "None";
        if (classContainer != null) {
            className = classContainer.getDisplayName();
        }
        if (raceContainer != null) {
            raceName = raceContainer.getDisplayName();
        }
        boolean hasPermForLocation = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.playerinfos.location");
        boolean hasPermForOthers = this.plugin.getPermissionManager().checkPermissionsSilent(sender, "RaC.playerinfos.others");
        sender.sendMessage(ChatColor.YELLOW + "=====" + ChatColor.RED + "PLAYER: " + ChatColor.AQUA + player.getName() + ChatColor.YELLOW + "=====");
        sender.sendMessage(ChatColor.YELLOW + "Race: " + ChatColor.RED + raceName);
        sender.sendMessage(ChatColor.YELLOW + "Class: " + ChatColor.RED + className);
        if (args.length == 0) {
            HashSet<ItemUtils.ItemQuality> armorPerms = new HashSet<ItemUtils.ItemQuality>();
            if (racPlayer.getRace() != null) {
                armorPerms.addAll(racPlayer.getRace().getArmorPerms());
            }
            if (racPlayer.getclass() != null) {
                armorPerms.addAll(racPlayer.getclass().getArmorPerms());
            }
            String allowed = "";
            for (ItemUtils.ItemQuality quality : armorPerms) {
                allowed = String.valueOf(allowed) + ", " + quality.getName();
            }
            if (!allowed.isEmpty()) {
                allowed = allowed.substring(2);
            }
            if (allowed.isEmpty()) {
                allowed = "None";
            }
            sender.sendMessage(ChatColor.YELLOW + "Allowed armor: " + ChatColor.RED + allowed);
        }
        if (hasPermForLocation) {
            sender.sendMessage(ChatColor.YELLOW + "---L--O--C--A--T--I--O--N---");
            sender.sendMessage(ChatColor.YELLOW + "World: " + ChatColor.AQUA + player.getWorld().getName());
            Location loc = player.getLocation();
            sender.sendMessage(ChatColor.YELLOW + "Position - X:" + ChatColor.AQUA + loc.getBlockX() + ChatColor.YELLOW + " Y:" + ChatColor.AQUA + loc.getBlockY() + ChatColor.YELLOW + " Z:" + ChatColor.AQUA + loc.getBlockZ());
        }
        if (hasPermForOthers) {
            Map<String, Double> boosts;
            ItemStack inHand = player.getInventory().getItem(player.getInventory().getHeldItemSlot());
            if (inHand == null) {
                inHand = new ItemStack(Material.AIR);
            }
            sender.sendMessage(ChatColor.YELLOW + "---O--T--H--E--R---");
            sender.sendMessage(ChatColor.YELLOW + "Item in Hand: " + ChatColor.AQUA + inHand.getType().toString());
            DecimalFormat format = new DecimalFormat("0.0");
            if (this.containsKey(args, "-health")) {
                HealthManager hm = racPlayer.getHealthManager();
                boosts = hm.getHealthBoosts();
                sender.sendMessage(ChatColor.YELLOW + "---Health-Boosts: " + boosts.size() + " ---");
                sender.sendMessage(ChatColor.YELLOW + "Current-Health: " + format.format(hm.getCurrentHealth()));
                sender.sendMessage(ChatColor.YELLOW + "Max-Health: " + format.format(hm.getMaxHealth()));
                for (Map.Entry<String, Double> entry : boosts.entrySet()) {
                    sender.sendMessage(ChatColor.YELLOW + " -" + entry.getKey() + ": " + format.format(entry.getValue()));
                }
            }
            if (this.containsKey(args, "-mana")) {
                ManaManager mm = racPlayer.getManaManager();
                boosts = mm.getAllBonuses();
                sender.sendMessage(ChatColor.YELLOW + "---Mana-Boosts: " + boosts.size() + " ---");
                sender.sendMessage(ChatColor.YELLOW + "Current-Mana: " + format.format(mm.getCurrentMana()));
                sender.sendMessage(ChatColor.YELLOW + "Max-Mana: " + format.format(mm.getMaxMana()));
                for (Map.Entry<String, Double> entry : boosts.entrySet()) {
                    sender.sendMessage(ChatColor.YELLOW + " -" + entry.getKey() + ": " + format.format(entry.getValue()));
                }
            }
        }
        return true;
    }

    private boolean containsKey(String[] args, String key) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.equalsIgnoreCase(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

