/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.force;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandExecutor_ForceRace
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_ForceRace() {
        super("racforcerace");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enableRaces()) {
            LanguageAPI.sendTranslatedMessage(sender, "something_disabled", "value", "Races");
            return true;
        }
        if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.forcechange")) {
            return true;
        }
        if (args.length < 2) {
            LanguageAPI.sendTranslatedMessage(sender, "wrong_command_use", "command", "/racforcerace <player> <race name>");
            return true;
        }
        String playerToChange = args[0];
        String newRace = args[1];
        RaCPlayer toChange = RaCPlayerManager.get().getPlayerByName(playerToChange);
        if (toChange == null) {
            LanguageAPI.sendTranslatedMessage(sender, "player_not_exist", "player", playerToChange);
            return true;
        }
        RaceManager raceManager = this.plugin.getRaceManager();
        if (raceManager.getHolderByName(newRace) == null) {
            LanguageAPI.sendTranslatedMessage(sender, "race_not_exist", "race", newRace);
            return true;
        }
        boolean worked = false;
        worked = raceManager.getHolderOfPlayer(toChange) == raceManager.getDefaultHolder() ? raceManager.addPlayerToHolder(toChange, newRace, true) : raceManager.changePlayerHolder(toChange, newRace, true);
        if (!worked) {
            sender.sendMessage(ChatColor.RED + "This did not work. :(");
            return true;
        }
        if (toChange.isOnline()) {
            LanguageAPI.sendTranslatedMessage(toChange, "race_changed_to", "race", newRace);
        }
        LanguageAPI.sendTranslatedMessage(sender, "race_changed_to_other", "race", newRace, "player", playerToChange);
        return true;
    }
}

