/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.force;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandExecutor_ForceClass
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_ForceClass() {
        super("racforceclass");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_classes_enable()) {
            LanguageAPI.sendTranslatedMessage(sender, "something_disabled", "value", "Class");
            return true;
        }
        if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.forcechange")) {
            return true;
        }
        if (args.length < 2) {
            LanguageAPI.sendTranslatedMessage(sender, "wrong_command_use", "command", "/racforceclass <player> <class name>");
            return true;
        }
        String playerToChange = args[0];
        String newClass = args[1];
        RaCPlayer toChange = RaCPlayerManager.get().getPlayerByName(playerToChange);
        if (toChange == null) {
            LanguageAPI.sendTranslatedMessage(sender, "player_not_exist", "player", playerToChange);
            return true;
        }
        ClassManager classManager = this.plugin.getClassManager();
        if (classManager.getHolderByName(newClass) == null) {
            LanguageAPI.sendTranslatedMessage(sender, "class_not_exist", "class", newClass);
            return true;
        }
        boolean worked = false;
        worked = classManager.getHolderOfPlayer(toChange) == classManager.getDefaultHolder() ? classManager.addPlayerToHolder(toChange, newClass, true) : classManager.changePlayerHolder(toChange, newClass, true);
        if (!worked) {
            sender.sendMessage(ChatColor.RED + "This did not work. :(");
            return true;
        }
        if (toChange.isOnline()) {
            LanguageAPI.sendTranslatedMessage(toChange, "class_changed_to", "class", newClass);
        }
        LanguageAPI.sendTranslatedMessage(sender, "class_changed_to_other", "player", toChange.getName(), "class", newClass);
        return true;
    }
}

