/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.debug;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DebugTimingEvents
implements Runnable {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private CommandSender sender;
    private long timing;
    private long calls;
    private long startTime;
    private int seconds;
    private int currentID;

    public DebugTimingEvents(CommandSender sender) {
        this.sender = sender;
        this.currentID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 0L, 20L);
        this.timing = 0L;
        this.seconds = 0;
        TraitEventManager.timingResults();
        TraitEventManager.getCalls();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.timing += TraitEventManager.timingResults();
        this.calls += TraitEventManager.getCalls();
        ++this.seconds;
        if (this.seconds > 10) {
            long takenMS = System.currentTimeMillis() - this.startTime;
            double percent = this.timing * 100L / takenMS;
            if (this.sender != null) {
                this.sender.sendMessage(ChatColor.GREEN + "Time taken in " + ChatColor.LIGHT_PURPLE + takenMS + ChatColor.GREEN + " milliseconds: " + ChatColor.LIGHT_PURPLE + this.timing + ChatColor.GREEN + " ms. This is: " + ChatColor.LIGHT_PURPLE + percent + ChatColor.GREEN + "% of the total computing time. There where " + ChatColor.LIGHT_PURPLE + this.calls + ChatColor.GREEN + " Event-calls.");
            }
            Bukkit.getScheduler().cancelTask(this.currentID);
            return;
        }
    }
}

