/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.debug;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.commands.debug.DebugTimingEvents;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor_RaceDebug
extends AbstractCommand {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandExecutor_RaceDebug() {
        super("racedebug", "rdebug");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        String commandString;
        if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.debug")) {
            return true;
        }
        if (args.length == 1) {
            String commandString2 = args[0];
            if (commandString2.equalsIgnoreCase("scan")) {
                long timeTook = this.runDebugScan();
                sender.sendMessage(ChatColor.GREEN + "Full Scan finished (" + timeTook + "ms) and logged in Debug file.");
                return true;
            }
            if (commandString2.equals("time")) {
                int hour = ((int)(Bukkit.getWorld((String)"world").getTime() / 1000L) + 6) % 24;
                boolean isNight = hour > 18 || hour < 6;
                boolean isDay = hour > 6 && hour < 18;
                sender.sendMessage(ChatColor.GREEN + "It is: " + (isNight ? ChatColor.RED + "Night" : "") + (isDay ? ChatColor.YELLOW + "Day" : ""));
                return true;
            }
            if (commandString2.equalsIgnoreCase("timing")) {
                sender.sendMessage(ChatColor.GREEN + "Profiling Event-Timings. Results in " + ChatColor.LIGHT_PURPLE + 10 + ChatColor.GREEN + " seconds.");
                new DebugTimingEvents(sender);
                return true;
            }
            if (commandString2.equalsIgnoreCase("clearcd")) {
                sender.sendMessage(ChatColor.GREEN + "CDs cleared");
                this.plugin.getCooldownManager().clearAllCooldowns();
                return true;
            }
            if (commandString2.equalsIgnoreCase("testerror")) {
                if (sender instanceof Player && !((Player)sender).isOp()) {
                    sender.sendMessage(ChatColor.RED + "You may not use this command!");
                    return true;
                }
                sender.sendMessage(ChatColor.GREEN + "Error is beeing fired!");
                try {
                    throw new NullPointerException("useless generated exeption.");
                }
                catch (NullPointerException e) {
                    String message = "Checking Error writing";
                    this.plugin.logStackTrace(message, e);
                    sender.sendMessage(ChatColor.GREEN + "Worked!");
                    return true;
                }
            }
            sender.sendMessage(ChatColor.RED + "No debug command found for: " + ChatColor.LIGHT_PURPLE + commandString2);
            return true;
        }
        if (args.length > 1 && (commandString = args[0]).equalsIgnoreCase("placeholder")) {
            Player player = (Player)sender;
            String[] more = new String[args.length - 1];
            System.arraycopy(args, 1, more, 0, args.length - 1);
            String result = RacesAndClasses.getPlugin().getAddinManager().getPlaceholderAPISupportManager().replace(player, StringUtils.join((Object[])args));
            sender.sendMessage(ChatColor.GREEN + "Result: " + result);
            return true;
        }
        this.postHelp(sender);
        return true;
    }

    private void postHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "Wrong usage. The correct usage is one of the following:");
        sender.sendMessage(ChatColor.RED + "/racedebug " + ChatColor.LIGHT_PURPLE + "scan");
        sender.sendMessage(ChatColor.RED + "/racedebug " + ChatColor.LIGHT_PURPLE + "timing");
        sender.sendMessage(ChatColor.RED + "/racedebug " + ChatColor.LIGHT_PURPLE + "testerror");
        sender.sendMessage(ChatColor.RED + "Others coming soon.");
    }

    private long runDebugScan() {
        long startTime = System.currentTimeMillis();
        this.plugin.getDebugLogger().log("------------------------------------------------------------------");
        this.plugin.getDebugLogger().log("Running Full debug Scan");
        Properties props = System.getProperties();
        this.plugin.getDebugLogger().log("============System Properties============");
        for (Object objProp : props.keySet()) {
            String prop = (String)objProp;
            String value = props.getProperty(prop);
            this.plugin.getDebugLogger().log("Property: " + prop + " value: " + value);
        }
        long timeTook = System.currentTimeMillis() - startTime;
        this.plugin.getDebugLogger().log("Full debug scan finished. It took: " + timeTook + "ms.");
        this.plugin.getDebugLogger().log("------------------------------------------------------------------");
        return timeTook;
    }
}

