/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.classes;

import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui.HolderInventory;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.PreClassChangeEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.PreClassSelectEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.util.RaC.chat.components.ChatMessageObject;
import de.tobiyas.util.RaC.chat.components.TellRawChatMessage;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CommandExecutor_Class
extends AbstractCommand {
    public CommandExecutor_Class() {
        super("class");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_classes_enable()) {
            LanguageAPI.sendTranslatedMessage(sender, "something_disabled", "value", "Classes");
            return true;
        }
        if (args.length == 0) {
            this.postHelp(sender);
            return true;
        }
        String potentialCommand = args[0];
        boolean isPlayer = sender instanceof Player;
        if (potentialCommand.equalsIgnoreCase("info")) {
            RaCPlayer racPlayer;
            AbstractTraitHolder classHolder = null;
            RaCPlayer raCPlayer = racPlayer = isPlayer ? RaCPlayerManager.get().getPlayer((Player)sender) : null;
            if (args.length < 2) {
                ClassContainer classContainer = classHolder = isPlayer ? racPlayer.getclass() : null;
                if (classHolder == null) {
                    LanguageAPI.sendTranslatedMessage(sender, "no_class_selected_use_info");
                    return true;
                }
            } else {
                String className = args[1];
                classHolder = this.plugin.getClassManager().getHolderByName(className);
                if (classHolder == null) {
                    LanguageAPI.sendTranslatedMessage(sender, "class_not_exist", "class", className);
                    return true;
                }
            }
            this.info(sender, classHolder);
            return true;
        }
        if (potentialCommand.equalsIgnoreCase("list")) {
            this.list(sender);
            return true;
        }
        if (potentialCommand.equalsIgnoreCase("select")) {
            if (!this.checkIsPlayer(sender)) {
                return true;
            }
            if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.class.select")) {
                return true;
            }
            Player player = (Player)sender;
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
            boolean useGUI = this.plugin.getConfigManager().getGeneralConfig().isConfig_useClassGUIToSelect();
            if (useGUI) {
                ClassContainer currentClass = racPlayer.getclass();
                if (currentClass != this.plugin.getClassManager().getDefaultHolder()) {
                    LanguageAPI.sendTranslatedMessage(sender, "already_have_class", "class", currentClass.getDisplayName());
                    return true;
                }
                PreClassSelectEvent ccEvent = new PreClassSelectEvent(player, (ClassContainer)this.plugin.getClassManager().getDefaultHolder());
                this.plugin.getServer().getPluginManager().callEvent((Event)ccEvent);
                if (ccEvent.isCancelled()) {
                    player.sendMessage(ChatColor.RED + "[RaC] " + ccEvent.getCancelMessage());
                    return true;
                }
                HolderInventory holderInventory = new HolderInventory(player, this.plugin.getClassManager());
                if (holderInventory.getNumberOfHolder() <= 0) {
                    LanguageAPI.sendTranslatedMessage(sender, "no_class_to_select");
                    return true;
                }
                player.openInventory((InventoryView)holderInventory);
                LanguageAPI.sendTranslatedMessage(sender, "open_holder", "holder", "Class");
                return true;
            }
            if (args.length == 1) {
                this.postHelp(sender);
                return true;
            }
            String potentialClass = args[1];
            this.select(player, potentialClass);
            return true;
        }
        if (potentialCommand.equalsIgnoreCase("book")) {
            if (!VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R1)) {
                sender.sendMessage(ChatColor.RED + "Only in MC 1.8+.");
                return true;
            }
            if (sender instanceof Player) {
                Player pl = (Player)sender;
                ItemStack book = this.generateClassesBook(RaCPlayerManager.get().getPlayer(pl));
                pl.getInventory().addItem(new ItemStack[]{book});
            }
            sender.sendMessage("Done");
            return true;
        }
        if (potentialCommand.equalsIgnoreCase("change")) {
            if (!this.checkIsPlayer(sender)) {
                return true;
            }
            if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.class.change")) {
                return true;
            }
            Player player = (Player)sender;
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer((Player)sender);
            boolean useGUI = this.plugin.getConfigManager().getGeneralConfig().isConfig_useClassGUIToSelect();
            if (useGUI) {
                ClassContainer currentClass = racPlayer.getclass();
                if (currentClass == this.plugin.getClassManager().getDefaultHolder()) {
                    LanguageAPI.sendTranslatedMessage(sender, "no_class_on_change");
                    return true;
                }
                PreClassSelectEvent ccEvent = new PreClassSelectEvent(player, (ClassContainer)this.plugin.getClassManager().getDefaultHolder());
                this.plugin.getServer().getPluginManager().callEvent((Event)ccEvent);
                if (ccEvent.isCancelled()) {
                    player.sendMessage(ChatColor.RED + "[RaC] " + ccEvent.getCancelMessage());
                    return true;
                }
                HolderInventory holderInventory = new HolderInventory(player, this.plugin.getClassManager());
                if (holderInventory.getNumberOfHolder() <= 0) {
                    LanguageAPI.sendTranslatedMessage(sender, "no_class_to_select");
                    return true;
                }
                player.openInventory((InventoryView)holderInventory);
                LanguageAPI.sendTranslatedMessage(sender, "open_holder", "holder", "Class");
                return true;
            }
            if (args.length == 1) {
                this.postHelp((CommandSender)player);
                return true;
            }
            String potentialClass = args[1];
            this.change(player, potentialClass);
            return true;
        }
        this.postHelp(sender);
        return true;
    }

    private boolean checkIsPlayer(CommandSender sender) {
        if (sender instanceof Player) {
            return true;
        }
        sender.sendMessage(LanguageAPI.translateIgnoreError("only_players").build());
        return false;
    }

    private void postHelp(CommandSender player) {
        LanguageAPI.sendTranslatedMessage(player, "wrong_command_use", "command", "");
        player.sendMessage(ChatColor.RED + "/class " + ChatColor.LIGHT_PURPLE + "info");
        player.sendMessage(ChatColor.RED + "/class " + ChatColor.LIGHT_PURPLE + "list");
        if (this.plugin.getPermissionManager().checkPermissionsSilent(player, "RaC.class.change")) {
            player.sendMessage(ChatColor.RED + "/class " + ChatColor.LIGHT_PURPLE + "select " + ChatColor.YELLOW + "<classname>");
        }
        if (this.plugin.getPermissionManager().checkPermissionsSilent(player, "RaC.class.select")) {
            player.sendMessage(ChatColor.RED + "/class " + ChatColor.LIGHT_PURPLE + "change " + ChatColor.YELLOW + "<classname>");
        }
    }

    private void info(CommandSender player, AbstractTraitHolder holder) {
        String armorString;
        ClassContainer classContainer = (ClassContainer)holder;
        player.sendMessage(ChatColor.YELLOW + "===== " + ChatColor.RED + "ClassInfo" + ChatColor.YELLOW + " =====");
        if (classContainer == null) {
            LanguageAPI.sendTranslatedMessage(player, "no_class_selected");
            return;
        }
        player.sendMessage(ChatColor.YELLOW + "Class HealthBonus: " + ChatColor.LIGHT_PURPLE + classContainer.getMaxHealthMod(1));
        player.sendMessage(ChatColor.YELLOW + "Class: " + ChatColor.LIGHT_PURPLE + classContainer.getDisplayName());
        player.sendMessage(ChatColor.YELLOW + "ClassTag: " + ChatColor.LIGHT_PURPLE + classContainer.getTag());
        double mana = classContainer.getManaBonus(1);
        if (mana > 0.0) {
            player.sendMessage(ChatColor.YELLOW + "+ Mana: " + ChatColor.AQUA + mana);
        }
        if (!(armorString = classContainer.getArmorString()).isEmpty()) {
            player.sendMessage(ChatColor.YELLOW + "Armor: " + ChatColor.AQUA + armorString);
        }
        player.sendMessage(ChatColor.YELLOW + "==== " + ChatColor.RED + "Class Traits" + ChatColor.YELLOW + " =====");
        for (Trait trait : classContainer.getVisibleTraits()) {
            player.sendMessage(ChatColor.BLUE + trait.getDisplayName() + " : " + trait.getPrettyConfiguration());
        }
        if (classContainer.getVisibleTraits().size() == 0) {
            player.sendMessage(ChatColor.BLUE + "No Traits.");
        }
    }

    private void list(CommandSender player) {
        player.sendMessage(ChatColor.YELLOW + "===== " + ChatColor.RED + "Classes" + ChatColor.YELLOW + " =====");
        List<String> classes = this.plugin.getClassManager().getAllHolderNames();
        if (classes.size() == 0) {
            player.sendMessage(LanguageAPI.translateIgnoreError("no_class_in_list").build());
            return;
        }
        String nameOfOwnClass = "";
        if (player instanceof Player) {
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer((Player)player);
            ClassContainer holder = racPlayer.getclass();
            nameOfOwnClass = holder != null ? holder.getDisplayName() : "";
        }
        for (String classe : classes) {
            Player pl;
            if (player instanceof Player && !this.hasPermission(pl = (Player)player, ClassAPI.getClassByName(classe))) continue;
            if (classe.equalsIgnoreCase(nameOfOwnClass)) {
                String yourClass = LanguageAPI.translateIgnoreError("your_class").build();
                player.sendMessage(ChatColor.RED + classe + ChatColor.YELLOW + "  <-- " + yourClass);
                continue;
            }
            player.sendMessage(ChatColor.BLUE + classe);
        }
    }

    private boolean hasPermission(Player player, ClassContainer holder) {
        PreClassSelectEvent event = null;
        event = new PreClassSelectEvent(player, holder, true, false);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    private boolean select(Player player, String potentialClass) {
        AbstractTraitHolder defaultHolder;
        boolean classExists;
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        potentialClass = potentialClass.toLowerCase();
        ClassContainer classContainer = (ClassContainer)this.plugin.getClassManager().getHolderByName(potentialClass);
        boolean bl = classExists = classContainer != null;
        if (!classExists) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "class_not_exist", "class", potentialClass);
            return false;
        }
        PreClassSelectEvent event = new PreClassSelectEvent(player, classContainer);
        this.plugin.fireEventToBukkit(event);
        if (event.isCancelled()) {
            player.sendMessage(ChatColor.RED + event.getCancelMessage());
            return false;
        }
        ClassContainer currentHolder = racPlayer.getclass();
        if (currentHolder == (defaultHolder = this.plugin.getClassManager().getDefaultHolder())) {
            if (this.plugin.getClassManager().addPlayerToHolder(racPlayer, potentialClass, true)) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "class_changed_to", "class", classContainer.getDisplayName());
                return true;
            }
            return false;
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)player, "already_have_class", "class", classContainer.getDisplayName());
        return false;
    }

    private void change(Player player, String potentialClass) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (!this.plugin.getPermissionManager().checkPermissions((CommandSender)player, "RaC.class.change")) {
            return;
        }
        ClassContainer oldClassContainer = (ClassContainer)this.plugin.getClassManager().getHolderOfPlayer(racPlayer);
        ClassContainer newClassContainer = (ClassContainer)this.plugin.getClassManager().getHolderByName(potentialClass);
        if (oldClassContainer == null) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "no_class_on_change");
            return;
        }
        if (newClassContainer == null) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "class_not_exist", "class", potentialClass);
            return;
        }
        if (oldClassContainer != null) {
            if (potentialClass.equalsIgnoreCase(oldClassContainer.getDisplayName())) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "change_to_same_holder", "holder", oldClassContainer.getDisplayName());
                return;
            }
            PreClassChangeEvent event = new PreClassChangeEvent(player, oldClassContainer, newClassContainer);
            this.plugin.fireEventToBukkit(event);
            if (event.isCancelled()) {
                player.sendMessage(ChatColor.RED + event.getCancelMessage());
                return;
            }
            if (this.plugin.getClassManager().changePlayerHolder(racPlayer, potentialClass, true)) {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "class_changed_to", "class", potentialClass);
            } else {
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "class_not_exist", "class", potentialClass);
            }
        }
    }

    private ItemStack generateClassesBook(RaCPlayer player) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setDisplayName(ChatColor.AQUA + ChatColor.UNDERLINE + "Classes");
        meta.setLore(Arrays.asList(ChatColor.AQUA + "This book contains", ChatColor.AQUA + "all Classes."));
        meta.setAuthor("RaC-Plugin");
        meta.setTitle(ChatColor.AQUA + ChatColor.UNDERLINE + "Classes");
        book.setItemMeta((ItemMeta)meta);
        LinkedList<TellRawChatMessage> pages = new LinkedList<TellRawChatMessage>();
        TellRawChatMessage firstPage = new TellRawChatMessage();
        pages.add(firstPage);
        firstPage.addSimpleText("Classes:", false, true, false, true, false, ChatColor.GRAY).addNewLine().addNewLine();
        int nr = 2;
        for (String raceName : ClassAPI.getAllClassNames()) {
            if (raceName.equals(ClassAPI.getDefaultClassName())) continue;
            ClassContainer container = ClassAPI.getClassByName(raceName);
            if (container != null) {
                pages.add(this.generateBookPageForClass(container, player));
            }
            firstPage.addSimpleText(container.getDisplayName(), false, true, false, false, false, ChatColor.AQUA).addSimpleText("  - page " + nr, false, false, false, false, false, ChatColor.GRAY).addNewLine();
            ++nr;
        }
        VollotileCodeManager.getVollotileCode().editBookToPages(book, pages);
        return book;
    }

    private TellRawChatMessage generateBookPageForClass(ClassContainer clazz, RaCPlayer player) {
        DecimalFormat f = new DecimalFormat("0.0");
        TellRawChatMessage page = new TellRawChatMessage();
        page.append(new ChatMessageObject("Class: " + clazz.getDisplayName()).addChatColor(ChatColor.GRAY).addBold().addUnderlined()).addNewLine().addNewLine().append(new ChatMessageObject("Armor").addChatColor(ChatColor.DARK_BLUE).addBold().removeUnderlined().addPopupHover(ChatColor.RED + clazz.getArmorString())).addSimpleText("/", false, false, false, false, false, ChatColor.GRAY).append(new ChatMessageObject("HealthBonus").addChatColor(ChatColor.BLUE).addBold().removeUnderlined().addPopupHover(ChatColor.RED + f.format(clazz.getMaxHealthMod(player.getCurrentLevel())))).addSimpleText("/", false, false, false, false, false, ChatColor.GRAY).append(new ChatMessageObject("Mana").addChatColor(ChatColor.AQUA).addBold().removeUnderlined().addPopupHover(ChatColor.RED + f.format(clazz.getManaBonus(player.getCurrentLevel())))).addNewLine().addNewLine().append(new ChatMessageObject("Traits:").addChatColor(ChatColor.GRAY).addBold().addUnderlined()).addNewLine();
        LinkedList<Trait> traits = new LinkedList<Trait>();
        traits.addAll(clazz.getVisibleTraits());
        Collections.sort(traits);
        for (Trait trait : clazz.getVisibleTraits()) {
            String popup = ChatColor.GRAY + ChatColor.UNDERLINE + ChatColor.BOLD + "Trait: " + trait.getDisplayName() + "\n" + ChatColor.RESET;
            if (trait instanceof TraitWithRestrictions) {
                TraitWithRestrictions twr = (TraitWithRestrictions)trait;
                if (twr.getMinLevel() > 1) {
                    popup = String.valueOf(popup) + ChatColor.GRAY + "MinLvl: " + ChatColor.RED + twr.getMinLevel() + "\n";
                }
                if (twr.getMaxLevel() < 100000) {
                    popup = String.valueOf(popup) + ChatColor.GRAY + "MaxLvl: " + ChatColor.RED + twr.getMaxLevel() + "\n";
                }
            }
            popup = String.valueOf(popup) + ChatColor.GRAY + "Description: " + ChatColor.RED + trait.getPrettyConfiguration();
            page.append(new ChatMessageObject("-" + trait.getDisplayName()).addChatColor(ChatColor.AQUA).removeBold().removeUnderlined().addPopupHover(popup)).addNewLine();
        }
        return page;
    }
}

