/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.chat;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.chat.PrivateChat;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.util.RaC.player.PlayerUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor_Whisper
extends AbstractCommand {
    public CommandExecutor_Whisper() {
        super("whisper", "w");
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_whisper_enable()) {
            sender.sendMessage(LanguageAPI.translateIgnoreError("something_disabled").replace("value", "Whispers").build());
            return true;
        }
        if (!this.plugin.getPermissionManager().checkPermissions(sender, "RaC.whisper")) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(LanguageAPI.translateIgnoreError("wrong_command_use").replace("command", "/whisper <target> <message>").build());
            return true;
        }
        Player target = null;
        String name = args[0];
        for (Player player : PlayerUtils.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(name) && !player.getDisplayName().equalsIgnoreCase(name)) continue;
            target = player;
            break;
        }
        if (target == null) {
            sender.sendMessage(LanguageAPI.translateIgnoreError("target_not_exist").build());
            return true;
        }
        if (args.length == 1) {
            sender.sendMessage(LanguageAPI.translateIgnoreError("wrong_command_use").replace("command", "/whisper <target> <message>").build());
            return true;
        }
        if (sender.getName().equals(target.getName())) {
            sender.sendMessage(LanguageAPI.translateIgnoreError("whisper_yourself").build());
            return true;
        }
        String message = "";
        int i = 1;
        while (i < args.length) {
            message = String.valueOf(message) + args[i] + " ";
            ++i;
        }
        PrivateChat.sendMessageToPlayer(sender, (CommandSender)target, message);
        return true;
    }
}

