/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands.bind;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.AbstractCommand;
import de.tobiyas.racesandclasses.hotkeys.HotKeyView;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CommandExecutor_BindTrait
extends AbstractCommand
implements Listener {
    private static final String BIND_KEY = ChatColor.AQUA + "Trait: ";
    private static final Material BindMat = Material.SHEARS;

    public CommandExecutor_BindTrait() {
        super("bindtrait", "bt", "bind", "obt");
        RacesAndClasses.getPlugin().registerEvents(this);
    }

    @Override
    public boolean onInternalCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && sender.isOp() && args[0].equals("reset")) {
            for (Player player : PlayerUtils.getOnlinePlayers()) {
                RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
                racPlayer.getHotkeyInventory().changeToBuildInv();
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_hotkeysEnabled()) {
            sender.sendMessage(ChatColor.RED + "Hotkeys are Disabled.");
            return true;
        }
        boolean useNewBindSystem = this.plugin.getConfigManager().getGeneralConfig().getConfig_useNewTraitBindSystem();
        RaCPlayer player = RaCPlayerManager.get().getPlayer((Player)sender);
        if (!player.hasPermission("RaC.bind")) {
            sender.sendMessage(ChatColor.RED + "You do not have Permission for this command.");
            return true;
        }
        if (sender.isOp() && args.length == 1 && args[0].equals("resync")) {
            player.getPlayer().updateInventory();
            return true;
        }
        if (useNewBindSystem) {
            boolean openView;
            boolean isBindingMode = player.getHotkeyInventory().isInSkillMode();
            boolean bl = openView = label.equalsIgnoreCase("obt") || args.length == 1 && args[0].equalsIgnoreCase("open");
            if (openView) {
                player.getPlayer().openInventory((InventoryView)new HotKeyView(player));
                return true;
            }
            if (isBindingMode) {
                player.getHotkeyInventory().changeToBuildInv();
                player.sendMessage("Change to Build Mode.");
            } else {
                player.getHotkeyInventory().changeToSkillInv();
                player.sendMessage("Change to Battle Skill.");
            }
            return true;
        }
        if (args.length < 1) {
            LanguageAPI.sendTranslatedMessage(player, "wrong_command_use", "command", "&c " + this.getCommandNames().iterator().next() + " <skill name>  or  /" + this.getCommandNames().iterator().next() + " list  to list all available Traits.");
            return true;
        }
        String spellName = StringUtils.join((Object[])args, (String)" ");
        if ("list".equalsIgnoreCase(args[0])) {
            String traits = ChatColor.GREEN + "Bindable Traits: ";
            for (Trait trait : player.getTraits()) {
                if (!trait.isBindable()) continue;
                traits = String.valueOf(traits) + " " + ChatColor.AQUA + trait.getDisplayName() + ChatColor.GREEN + ",";
            }
            sender.sendMessage(traits);
            return true;
        }
        Trait selected = null;
        for (Trait trait : player.getTraits()) {
            if (!trait.getName().equalsIgnoreCase(spellName) && !trait.getDisplayName().equalsIgnoreCase(spellName) || !trait.isBindable()) continue;
            selected = trait;
            break;
        }
        if (selected == null) {
            LanguageAPI.sendTranslatedMessage(sender, "no_find_trait");
            return true;
        }
        int slotNumber = player.getPlayer().getInventory().getHeldItemSlot();
        ItemStack heldItem = player.getPlayer().getItemInHand();
        if (heldItem != null && heldItem.getType() != Material.AIR) {
            player.sendTranslatedMessage("held_item_not_air");
            return true;
        }
        ItemStack item = CommandExecutor_BindTrait.generate(selected);
        player.getPlayer().getInventory().setItem(slotNumber, item);
        player.sendMessage(ChatColor.GREEN + selected.getDisplayName() + " Slot: " + slotNumber);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        LinkedList<String> values = new LinkedList<String>();
        if (!(sender instanceof Player)) {
            return values;
        }
        if (args.length == 1) {
            for (Trait trait : RaCPlayerManager.get().getPlayer((Player)sender).getTraits()) {
                if (!trait.isBindable() || !trait.getDisplayName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                values.add(trait.getDisplayName());
            }
        }
        return values;
    }

    public static ItemStack generate(Trait trait) {
        ItemStack item = new ItemStack(BindMat);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.valueOf(BIND_KEY) + trait.getDisplayName());
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("Switch the item to this slot to cast the Spell,");
        lore.add("or simply right-click with it.");
        lore.add("");
        lore.add(ChatColor.YELLOW + trait.getPrettyConfiguration());
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        return item;
    }
}

