/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.CommandInterface;
import de.tobiyas.racesandclasses.commands.bind.CommandExecutor_BindTrait;
import de.tobiyas.racesandclasses.commands.bind.CommandExecutor_UseTrait;
import de.tobiyas.racesandclasses.commands.chat.CommandExecutor_LocalChat;
import de.tobiyas.racesandclasses.commands.chat.CommandExecutor_Whisper;
import de.tobiyas.racesandclasses.commands.chat.channels.CommandExecutor_BroadCast;
import de.tobiyas.racesandclasses.commands.chat.channels.CommandExecutor_Channel;
import de.tobiyas.racesandclasses.commands.chat.channels.CommandExecutor_Racechat;
import de.tobiyas.racesandclasses.commands.classes.CommandExecutor_Class;
import de.tobiyas.racesandclasses.commands.config.CommandExecutor_ConfigRegenerate;
import de.tobiyas.racesandclasses.commands.debug.CommandExecutor_Edit;
import de.tobiyas.racesandclasses.commands.debug.CommandExecutor_RaceDebug;
import de.tobiyas.racesandclasses.commands.force.CommandExecutor_ForceClass;
import de.tobiyas.racesandclasses.commands.force.CommandExecutor_ForceRace;
import de.tobiyas.racesandclasses.commands.general.CommandExecutor_EmptyCommand;
import de.tobiyas.racesandclasses.commands.general.CommandExecutor_PlayerInfo;
import de.tobiyas.racesandclasses.commands.general.CommandExecutor_RacesReload;
import de.tobiyas.racesandclasses.commands.health.CommandExecutor_HP;
import de.tobiyas.racesandclasses.commands.health.CommandExecutor_Mana;
import de.tobiyas.racesandclasses.commands.health.CommandExecutor_RaceGod;
import de.tobiyas.racesandclasses.commands.health.CommandExecutor_RaceHeal;
import de.tobiyas.racesandclasses.commands.health.CommandExecutor_ShowTraits;
import de.tobiyas.racesandclasses.commands.help.CommandExecutor_PermissionCheck;
import de.tobiyas.racesandclasses.commands.help.CommandExecutor_RaceHelp;
import de.tobiyas.racesandclasses.commands.help.CommandExecutor_RacesVersion;
import de.tobiyas.racesandclasses.commands.help.CommandExecutor_TraitList;
import de.tobiyas.racesandclasses.commands.level.Command_RACLevel;
import de.tobiyas.racesandclasses.commands.pets.Command_RaCPet;
import de.tobiyas.racesandclasses.commands.races.CommandExecutor_Race;
import de.tobiyas.racesandclasses.commands.racespawn.CommandExecutor_RaceSpawn;
import de.tobiyas.racesandclasses.commands.reflect.CommandMap;
import de.tobiyas.racesandclasses.commands.skilltree.CommandExecutor_SkillTree;
import de.tobiyas.racesandclasses.commands.statistics.CommandExecutor_Statistics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommandRegisterer {
    protected final List<CommandInterface> commands = new LinkedList<CommandInterface>();
    protected final RacesAndClasses plugin;

    public CommandRegisterer(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public void registerCommands() {
        long currentTime = System.currentTimeMillis();
        this.commands.clear();
        this.commands.add(new CommandExecutor_Race());
        this.commands.add(new CommandExecutor_Racechat());
        this.commands.add(new CommandExecutor_RaceHelp());
        this.commands.add(new CommandExecutor_Whisper());
        this.commands.add(new CommandExecutor_TraitList());
        this.commands.add(new CommandExecutor_RaceHeal());
        this.commands.add(new CommandExecutor_RaceDebug());
        this.commands.add(new CommandExecutor_Class());
        this.commands.add(new CommandExecutor_HP());
        this.commands.add(new CommandExecutor_Mana());
        this.commands.add(new CommandExecutor_Channel());
        this.commands.add(new CommandExecutor_RaceGod());
        this.commands.add(new CommandExecutor_BroadCast());
        this.commands.add(new CommandExecutor_LocalChat());
        this.commands.add(new CommandExecutor_PlayerInfo());
        this.commands.add(new CommandExecutor_PermissionCheck());
        this.commands.add(new CommandExecutor_RacesReload());
        this.commands.add(new CommandExecutor_RacesVersion());
        this.commands.add(new CommandExecutor_Statistics());
        this.commands.add(new CommandExecutor_ShowTraits());
        this.commands.add(new CommandExecutor_Edit());
        this.commands.add(new CommandExecutor_ForceRace());
        this.commands.add(new CommandExecutor_ForceClass());
        this.commands.add(new CommandExecutor_ConfigRegenerate());
        this.commands.add(new CommandExecutor_RaceSpawn());
        this.commands.add(new Command_RACLevel());
        this.commands.add(new Command_RaCPet());
        this.commands.add(new CommandExecutor_BindTrait());
        this.commands.add(new CommandExecutor_UseTrait());
        this.commands.add(new CommandExecutor_SkillTree());
        Map<String, String> remap = this.plugin.getConfigManager().getGeneralConfig().getConfig_command_remaps();
        for (CommandInterface command : this.commands) {
            command.applyRemapping(remap);
        }
        List<String> disabledCommands = this.plugin.getConfigManager().getGeneralConfig().getConfig_general_disable_commands();
        Iterator<CommandInterface> it = this.commands.iterator();
        while (it.hasNext()) {
            CommandInterface command = it.next();
            command.filterToDisabledCommands(disabledCommands);
            if (command.hasAnyCommand()) continue;
            it.remove();
        }
        CommandMap.registerCommands(this.commands, this.plugin);
        if (System.currentTimeMillis() - currentTime > 1000L) {
            this.plugin.log("Took too long to Init all commands! Please report this. Time taken: " + (System.currentTimeMillis() - currentTime) + " mSecs.");
        }
    }

    public void registerAllCommandsAsError() {
        for (CommandInterface command : this.commands) {
            new CommandExecutor_EmptyCommand(command.getCommandNames());
        }
    }
}

