/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.commands;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.CommandInterface;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public abstract class AbstractCommand
implements CommandInterface {
    protected final Collection<String> commandNames = new HashSet<String>();
    protected final Collection<String> aliases = new HashSet<String>();
    protected final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    protected String description = "No description provided.";

    public AbstractCommand(String commandName) {
        this.commandNames.add(commandName);
    }

    public AbstractCommand(String commandName, String ... aliases) {
        this.commandNames.add(commandName);
        this.aliases.addAll(Arrays.asList(aliases));
    }

    @Override
    public Collection<String> getCommandNames() {
        return this.commandNames;
    }

    @Override
    public String[] getAliases() {
        return this.aliases.toArray(new String[this.aliases.size()]);
    }

    @Override
    public boolean hasAliases() {
        return this.aliases != null && this.aliases.size() > 0;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return new LinkedList<String>();
    }

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            return this.onInternalCommand(sender, command, label, args);
        }
        catch (Throwable exp) {
            this.plugin.getDebugLogger().logStackTrace("Error on command '" + label + "' for '" + sender.getName() + "' args: '" + StringUtils.join((Object[])args, (String)" ") + "'", exp);
            return true;
        }
    }

    protected abstract boolean onInternalCommand(CommandSender var1, Command var2, String var3, String[] var4);

    @Override
    public void filterToDisabledCommands(Collection<String> disabled) {
        for (String name : disabled) {
            Iterator<String> it = this.aliases.iterator();
            while (it.hasNext()) {
                if (!name.equalsIgnoreCase(it.next())) continue;
                it.remove();
            }
            it = this.commandNames.iterator();
            while (it.hasNext()) {
                if (!name.equalsIgnoreCase(it.next())) continue;
                it.remove();
            }
        }
    }

    @Override
    public boolean hasAnyCommand() {
        return !this.commandNames.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void applyRemapping(Map<String, String> remaps) {
        block0: for (String key : remaps.keySet()) {
            String replacement = remaps.get(key);
            for (String command : this.commandNames) {
                if (!command.equalsIgnoreCase(key)) continue;
                this.commandNames.remove(command);
                this.commandNames.add(replacement);
                break;
            }
            for (String alias : this.aliases) {
                if (!alias.equalsIgnoreCase(key)) continue;
                this.aliases.remove(alias);
                this.aliases.add(replacement);
                continue block0;
            }
        }
    }
}

