/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.chat.channels.container;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public class MuteContainer {
    private final HashMap<RaCPlayer, Integer> muted = new HashMap();

    public MuteContainer() {
    }

    public MuteContainer(YAMLConfigExtended config, String channelPre) {
        Set<String> mutedPlayers = config.getChildren(String.valueOf(channelPre) + ".muted");
        for (String player : mutedPlayers) {
            try {
                UUID id = UUID.fromString(player);
                RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(id);
                int time = config.getInt(String.valueOf(channelPre) + ".muted." + player);
                this.muted.put(racPlayer, time);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public boolean mutePlayer(RaCPlayer player, int time) {
        if (!this.muted.containsKey(player)) {
            this.muted.put(player, time);
            return true;
        }
        return false;
    }

    public boolean unmutePlayer(RaCPlayer player) {
        return this.muted.remove(player) != null;
    }

    public void saveContainer(YAMLConfigExtended config, String channelPre) {
        for (RaCPlayer name : this.muted.keySet()) {
            int time = this.muted.get(name);
            config.set(String.valueOf(channelPre) + ".muted." + name.getUniqueId(), time);
        }
        if (this.muted.keySet().size() == 0) {
            config.set(String.valueOf(channelPre) + ".muted.empty", true);
        }
    }

    public int isMuted(RaCPlayer player) {
        return this.muted.containsKey(player) ? this.muted.get(player) : -1;
    }

    public void tick() {
        for (RaCPlayer name : this.muted.keySet()) {
            int duration = this.muted.get(name);
            if (duration == Integer.MAX_VALUE) continue;
            if (--duration < 0) {
                this.muted.remove(name);
                continue;
            }
            this.muted.put(name, duration);
        }
    }
}

