/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.chat.channels.container;

import com.avaje.ebean.validation.NotEmpty;
import com.avaje.ebean.validation.NotNull;
import de.tobiyas.racesandclasses.util.chat.ChannelLevel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Entity
@Table(name="_channel_settings")
public class ChannelSaveContainer {
    @Id
    @NotEmpty
    private String channelName;
    @NotNull
    private String channelPassword;
    @NotNull
    private String channelAdmin;
    @Embedded
    private ChannelLevel channelLevel;
    @NotNull
    private String participants;
    @NotNull
    private String bannedMap;
    @NotNull
    private String mutedMap;
    @NotEmpty
    private String prefix;
    @NotEmpty
    private String suffix;
    @NotEmpty
    private String channelColor;
    @NotEmpty
    private String channelFormat;

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelPassword() {
        return this.channelPassword;
    }

    public void setChannelPassword(String channelPassword) {
        this.channelPassword = channelPassword;
    }

    public String getChannelAdmin() {
        return this.channelAdmin;
    }

    public void setChannelAdmin(String channelAdmin) {
        this.channelAdmin = channelAdmin;
    }

    public ChannelLevel getChannelLevel() {
        return this.channelLevel;
    }

    public void setChannelLevel(ChannelLevel channelLevel) {
        this.channelLevel = channelLevel;
    }

    public String getParticipants() {
        return this.participants;
    }

    @Deprecated
    public void setParticipants(String participants) {
        this.participants = participants;
    }

    @Deprecated
    public String getBannedMap() {
        return this.bannedMap;
    }

    @Deprecated
    public void setBannedMap(String bannedMap) {
        this.bannedMap = bannedMap;
    }

    @Deprecated
    public String getMutedMap() {
        return this.mutedMap;
    }

    @Deprecated
    public void setMutedMap(String mutedMap) {
        this.mutedMap = mutedMap;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getChannelColor() {
        return this.channelColor;
    }

    public void setChannelColor(String channelColor) {
        this.channelColor = channelColor;
    }

    public String getChannelFormat() {
        return this.channelFormat;
    }

    public void setChannelFormat(String channelFormat) {
        this.channelFormat = channelFormat;
    }

    public List<String> generateParitipants() {
        try {
            LinkedList<String> participants = new LinkedList<String>();
            JSONArray tempObject = (JSONArray)new JSONParser().parse(this.participants);
            if (tempObject == null || tempObject.size() == 0) {
                return participants;
            }
            int i = 0;
            while (i < tempObject.size()) {
                participants.add(tempObject.get(i).toString());
                ++i;
            }
            return participants;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new LinkedList<String>();
        }
    }

    public void saveParticipants(List<String> participants) {
        JSONArray tempObject = new JSONArray();
        for (String playerName : participants) {
            tempObject.add((Object)playerName);
        }
        this.participants = tempObject.toJSONString();
    }

    public void saveBannedMap(Map<String, Integer> banned) {
        this.bannedMap = this.parseMapToString(banned);
    }

    public Map<String, Integer> generateBannedMap() {
        return this.parseStringToMap(this.bannedMap);
    }

    public void saveMutedMap(Map<String, Integer> banned) {
        this.mutedMap = this.parseMapToString(banned);
    }

    public Map<String, Integer> generateMutedMap() {
        return this.parseStringToMap(this.mutedMap);
    }

    private String parseMapToString(Map<String, Integer> map) {
        JSONObject tempObject = new JSONObject();
        for (Map.Entry<String, Integer> player : map.entrySet()) {
            tempObject.put((Object)player.getKey(), (Object)player.getValue());
        }
        return tempObject.toJSONString();
    }

    private Map<String, Integer> parseStringToMap(String parseable) {
        try {
            HashMap<String, Integer> bannedmap = new HashMap<String, Integer>();
            JSONObject tempObject = (JSONObject)new JSONParser().parse(parseable);
            if (tempObject == null || tempObject.size() == 0) {
                return bannedmap;
            }
            Set entrySet = tempObject.entrySet();
            for (String entry : entrySet) {
                int value = (Integer)tempObject.get((Object)entry);
                bannedmap.put(entry, value);
            }
            return bannedmap;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new HashMap<String, Integer>();
        }
    }
}

