/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.chat.channels.container;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.chat.ChatFormatter;
import de.tobiyas.racesandclasses.chat.channels.container.BanContainer;
import de.tobiyas.racesandclasses.chat.channels.container.ChannelInvalidException;
import de.tobiyas.racesandclasses.chat.channels.container.ChannelTicker;
import de.tobiyas.racesandclasses.chat.channels.container.MuteContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.chat.ChannelLevel;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChannelContainer {
    private final RacesAndClasses plugin;
    private String channelName;
    private ChatFormatter channelFormat;
    private String channelPassword;
    private RaCPlayer channelAdmin = null;
    private ChannelLevel channelLevel;
    private ArrayList<RaCPlayer> participants;
    private MuteContainer muteContainer;
    private BanContainer banContainer;

    public ChannelContainer(String channelName, ChannelLevel level) throws ChannelInvalidException {
        this.plugin = RacesAndClasses.getPlugin();
        this.channelName = channelName;
        this.channelLevel = level;
        String prefix = "&f[";
        String suffix = "&f]";
        this.channelPassword = "";
        this.participants = new ArrayList();
        this.muteContainer = new MuteContainer();
        this.banContainer = new BanContainer();
        this.adaptFormatingToLevel();
        this.channelFormat.setPrefix(prefix);
        this.channelFormat.setSuffix(suffix);
        this.rescanPartitions(null);
        ChannelTicker.registerChannel(this);
        if (this.channelLevel == ChannelLevel.RaceChannel) {
            boolean raceExists;
            boolean bl = raceExists = this.plugin.getRaceManager().getHolderByName(this.channelName) != null;
            if (!raceExists) {
                throw new ChannelInvalidException();
            }
        }
    }

    private ChannelContainer(String channelName, ChannelLevel level, YAMLConfigExtended config) {
        boolean forceOverride;
        this.participants = new ArrayList();
        this.channelLevel = level;
        this.channelName = channelName;
        this.plugin = RacesAndClasses.getPlugin();
        config.load();
        String channelPre = "channel." + level.name() + "." + channelName;
        String prefix = config.getString(String.valueOf(channelPre) + ".prefix", "&f[");
        String suffix = config.getString(String.valueOf(channelPre) + ".suffix", "&f]");
        String channelColor = config.getString(String.valueOf(channelPre) + ".channelColor", this.plugin.getConfigManager().getChannelConfig().getConfig_channel_default_color());
        String stdFormat = config.getString(String.valueOf(channelPre) + ".channelFormat", this.plugin.getConfigManager().getChannelConfig().getConfig_channel_default_format());
        RaceContainer raceContainer = (RaceContainer)this.plugin.getRaceManager().getHolderByName(channelName);
        boolean bl = forceOverride = this.channelLevel == ChannelLevel.RaceChannel && raceContainer != null;
        if (forceOverride) {
            channelColor = raceContainer.getRaceChatColor();
            stdFormat = raceContainer.getRaceChatFormat();
        }
        this.channelPassword = config.getString(String.valueOf(channelPre) + ".channelPassword", "");
        try {
            UUID id = UUID.fromString(config.getString(String.valueOf(channelPre) + ".channelAdmin", ""));
            this.channelAdmin = RaCPlayerManager.get().getPlayer(id);
        }
        catch (IllegalArgumentException id) {
            // empty catch block
        }
        this.muteContainer = new MuteContainer(config, channelPre);
        this.banContainer = new BanContainer(config, channelPre);
        List<String> tempList = config.getStringList(String.valueOf(channelPre) + ".members");
        for (String uuid : tempList) {
            try {
                UUID id = UUID.fromString(uuid);
                RaCPlayer player = RaCPlayerManager.get().getPlayer(id);
                this.participants.add(player);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.channelFormat = new ChatFormatter(channelName, channelColor, this.channelLevel, stdFormat);
        this.channelFormat.setPrefix(prefix);
        this.channelFormat.setSuffix(suffix);
        if (!config.getBoolean(String.valueOf(channelPre) + ".saveLoad", false)) {
            this.rescanPartitions(null);
        }
        config.set(String.valueOf(channelPre) + ".saveLoad", false);
        config.save();
        ChannelTicker.registerChannel(this);
    }

    private void adaptFormatingToLevel() {
        String stdFormat = "";
        String stdColor = "";
        switch (this.channelLevel) {
            case GlobalChannel: {
                stdColor = this.plugin.getConfigManager().getChannelConfig().getConfig_globalchat_default_color();
                stdFormat = this.plugin.getConfigManager().getChannelConfig().getConfig_globalchat_default_format();
                break;
            }
            case WorldChannel: {
                stdColor = this.plugin.getConfigManager().getChannelConfig().getConfig_worldchat_default_color();
                stdFormat = this.plugin.getConfigManager().getChannelConfig().getConfig_worldchat_default_format();
                break;
            }
            case RaceChannel: {
                RaceContainer raceContainer = (RaceContainer)this.plugin.getRaceManager().getHolderByName(this.channelName);
                if (raceContainer == null) {
                    stdColor = this.plugin.getConfigManager().getChannelConfig().getConfig_racechat_default_color();
                    stdFormat = this.plugin.getConfigManager().getChannelConfig().getConfig_racechat_default_format();
                    break;
                }
                stdColor = raceContainer.getRaceChatColor();
                stdFormat = raceContainer.getRaceChatFormat();
                break;
            }
            case LocalChannel: {
                stdColor = this.plugin.getConfigManager().getChannelConfig().getConfig_localchat_default_color();
                stdFormat = this.plugin.getConfigManager().getChannelConfig().getConfig_localchat_default_format();
                break;
            }
            default: {
                stdColor = this.plugin.getConfigManager().getChannelConfig().getConfig_channel_default_color();
                stdFormat = this.plugin.getConfigManager().getChannelConfig().getConfig_channel_default_format();
            }
        }
        this.channelFormat = new ChatFormatter(this.channelName, stdColor, this.channelLevel, stdFormat);
    }

    public void setPassword(String password) {
        if (this.channelLevel == ChannelLevel.PasswordChannel) {
            this.channelPassword = password;
        }
    }

    protected String getPassword() {
        return this.channelPassword;
    }

    public void banAndRemovePlayer(RaCPlayer player, int time) {
        this.banContainer.banPlayer(player, time);
        if (this.isMember(player)) {
            this.removePlayerFromChannel(player, false);
        }
    }

    public void unbanPlayer(RaCPlayer player) {
        this.banContainer.unbanPlayer(player);
    }

    public void mutePlayer(RaCPlayer player, int time) {
        this.muteContainer.mutePlayer(player, time);
    }

    public void unmutePlayer(RaCPlayer player) {
        this.muteContainer.unmutePlayer(player);
    }

    public void setAdmin(RaCPlayer player) {
        if (!this.participants.contains(player)) {
            this.participants.add(player);
        }
        this.channelAdmin = player;
    }

    public RaCPlayer getAdmin() {
        return this.channelAdmin;
    }

    public void saveChannel(YAMLConfigExtended config) {
        if (this.channelLevel == ChannelLevel.LocalChannel) {
            return;
        }
        LinkedList<String> participants = new LinkedList<String>();
        for (RaCPlayer id : this.participants) {
            if (id == null) continue;
            participants.add(id.getUniqueId().toString());
        }
        config.load();
        String channelPre = "channel." + this.channelLevel.name() + "." + this.channelName;
        config.createSection(channelPre);
        config.set(String.valueOf(channelPre) + ".prefix", this.channelFormat.getPrefix());
        config.set(String.valueOf(channelPre) + ".suffix", this.channelFormat.getSuffix());
        config.set(String.valueOf(channelPre) + ".channelColor", this.channelFormat.getColor());
        if (participants.size() > 0) {
            config.set(String.valueOf(channelPre) + ".members", participants);
        }
        config.set(String.valueOf(channelPre) + ".channelFormat", this.channelFormat.getFormat());
        config.set(String.valueOf(channelPre) + ".channelPassword", this.channelPassword);
        config.set(String.valueOf(channelPre) + ".channelAdmin", this.channelAdmin);
        config.set(String.valueOf(channelPre) + ".saveLoad", true);
        this.banContainer.saveContainer(config, channelPre);
        this.muteContainer.saveContainer(config, channelPre);
        config.save();
    }

    public static ChannelContainer constructFromYml(YAMLConfigExtended config, String channelName, ChannelLevel level) throws ChannelInvalidException {
        try {
            return new ChannelContainer(channelName, level, config);
        }
        catch (Exception exp) {
            throw new ChannelInvalidException();
        }
    }

    public void addPlayerToChannel(RaCPlayer player, String password, boolean notify) {
        String joinMessage;
        AbstractTraitHolder container;
        if (this.participants.contains(player)) {
            player.sendMessage(ChatColor.RED + "You are already member of this channel.");
            return;
        }
        int isBanned = this.banContainer.isBanned(player);
        if (isBanned != -1) {
            String time = this.getTimeString(isBanned);
            player.sendMessage(ChatColor.RED + "You are banned from this channel for: " + ChatColor.LIGHT_PURPLE + time);
            return;
        }
        if (!(this.channelLevel != ChannelLevel.RaceChannel || (container = this.plugin.getRaceManager().getHolderOfPlayer(player)) != null && container.getDisplayName().equalsIgnoreCase(this.channelName))) {
            player.sendMessage(ChatColor.RED + "You don't belong to this race.");
            return;
        }
        if (this.channelLevel == ChannelLevel.WorldChannel && !player.getWorld().getName().equalsIgnoreCase(this.channelName)) {
            player.sendMessage(ChatColor.RED + "You are not on this world.");
            return;
        }
        if (!this.channelPassword.equals("") && !password.equals(this.channelPassword)) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + "Wrong password.");
            }
            return;
        }
        this.participants.add(player);
        if (player != null && notify && !(joinMessage = this.plugin.getConfigManager().getChannelConfig().getConfig_PlayerJoinFormat()).isEmpty()) {
            this.sendMessageInChannel((CommandSender)player.getPlayer(), "", joinMessage);
        }
    }

    public void removePlayerFromChannel(RaCPlayer player, boolean notify) {
        String leaveMessage;
        if (!this.participants.contains(player) && player != null) {
            player.sendMessage(ChatColor.RED + "You are no member of this channel.");
            return;
        }
        if (player != null && notify && !(leaveMessage = this.plugin.getConfigManager().getChannelConfig().getConfig_PlayerLeaveFormat()).isEmpty()) {
            this.sendMessageInChannel((CommandSender)player.getPlayer(), "", leaveMessage);
        }
        this.participants.remove(player);
        if (this.channelLevel == ChannelLevel.PasswordChannel || this.channelLevel == ChannelLevel.PrivateChannel || this.channelLevel == ChannelLevel.PublicChannel) {
            if (this.participants.size() == 0) {
                this.plugin.getChannelManager().removeChannel(this.channelName);
                return;
            }
            if (player.equals(this.channelAdmin)) {
                RaCPlayer oldChannelAdmin = this.channelAdmin;
                RaCPlayer newChannelAdmin = this.participants.get(0);
                this.setAdmin(newChannelAdmin);
                this.sendMessageInChannel(null, "Channel-Admin changed from: " + ChatColor.RED + oldChannelAdmin + " TO " + newChannelAdmin, "");
            }
        }
    }

    public ArrayList<RaCPlayer> getAllParticipants() {
        return this.participants;
    }

    public void sendMessageInChannel(CommandSender sender, String message, String forceFormat) {
        int isMuted;
        RaCPlayer racPlayer;
        if (forceFormat == null || forceFormat.isEmpty()) {
            forceFormat = this.channelFormat.getFormat();
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        RaCPlayer raCPlayer = racPlayer = player == null ? null : RaCPlayerManager.get().getPlayer(player);
        if (this.channelLevel == ChannelLevel.LocalChannel && sender instanceof Player) {
            this.rescanPartitions((Player)sender);
        }
        if (player != null && (isMuted = this.muteContainer.isMuted(racPlayer)) != -1) {
            String time = this.getTimeString(isMuted);
            sender.sendMessage(ChatColor.RED + "You are muted in this channel for: " + ChatColor.LIGHT_PURPLE + time);
            return;
        }
        HashSet<Player> players = new HashSet<Player>();
        for (RaCPlayer member : this.participants) {
            if (member == null || !member.isOnline()) continue;
            players.add(member.getPlayer());
        }
        AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(!Bukkit.isPrimaryThread(), player, message, players);
        event.setFormat(forceFormat);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        String modifiedMessage = "";
        modifiedMessage = sender == null ? this.modifyMessageToPlayer(null, event.getMessage(), event.getFormat()) : this.modifyMessageToPlayer(racPlayer, event.getMessage(), event.getFormat());
        for (Player recipient : event.getRecipients()) {
            recipient.sendMessage(modifiedMessage);
        }
    }

    private void rescanPartitions(Player localPlayer) {
        switch (this.channelLevel) {
            case GlobalChannel: {
                if (!this.channelName.equalsIgnoreCase("Global")) {
                    return;
                }
                this.participants.clear();
                for (Player player : PlayerUtils.getOnlinePlayers()) {
                    RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
                    this.participants.add(racPlayer);
                }
                break;
            }
            case WorldChannel: {
                this.participants.clear();
                for (Player player : Bukkit.getWorld((String)this.channelName).getPlayers()) {
                    RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
                    this.participants.add(racPlayer);
                }
                break;
            }
            case RaceChannel: {
                this.participants.clear();
                RaceContainer container = (RaceContainer)this.plugin.getRaceManager().getHolderByName(this.channelName);
                if (container == null) break;
                List<RaCPlayer> allPlayersOfRace = this.plugin.getRaceManager().getAllPlayersOfHolder(container);
                for (RaCPlayer player : allPlayersOfRace) {
                    this.participants.add(player);
                }
                break;
            }
            case LocalChannel: {
                this.participants.clear();
                if (localPlayer == null) {
                    return;
                }
                int distance = this.plugin.getConfigManager().getChannelConfig().getConfig_localchat_range();
                Location loc = localPlayer.getLocation();
                for (Player tempPlayer : loc.getWorld().getPlayers()) {
                    if (!(loc.distance(tempPlayer.getLocation()) < (double)distance)) continue;
                    RaCPlayer player = RaCPlayerManager.get().getPlayer(tempPlayer);
                    this.participants.add(player);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private String modifyMessageToPlayer(RaCPlayer player, String message, String forceFormat) {
        return this.channelFormat.format(player, message, forceFormat, true);
    }

    private String getTimeString(int timeInSec) {
        String time = "";
        int orgSeconds = timeInSec * 1000;
        int seconds = orgSeconds / 1000 % 60;
        int minutes = orgSeconds / 60000 % 60;
        int hours = orgSeconds / 3600000 % 24;
        if (hours != 0) {
            time = String.valueOf(time) + hours + " hours, ";
        }
        if (minutes != 0) {
            time = String.valueOf(time) + minutes + " minutes, ";
        }
        if (seconds != 0) {
            time = String.valueOf(time) + seconds + " seconds";
        }
        if (timeInSec == Integer.MAX_VALUE) {
            time = " ever";
        }
        return time;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void postInfo(CommandSender sender) {
        int isBanned;
        int isMuted;
        Player player = sender instanceof Player ? (Player)sender : null;
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        sender.sendMessage(ChatColor.YELLOW + "ChannelName: " + ChatColor.AQUA + this.channelName);
        sender.sendMessage(ChatColor.YELLOW + "ChannelLevel: " + ChatColor.AQUA + this.channelLevel.name());
        sender.sendMessage(ChatColor.YELLOW + "ChannelColor: " + ChatColor.translateAlternateColorCodes((char)'&', (String)this.channelFormat.getColor()) + "COLOR");
        sender.sendMessage(ChatColor.YELLOW + "ChannelFormat: " + ChatColor.RESET + ChatColor.translateAlternateColorCodes((char)'&', (String)this.channelFormat.getFormat()));
        if (player != null && player.getUniqueId().equals(this.channelAdmin)) {
            sender.sendMessage(ChatColor.YELLOW + "ChannelPassword: " + ChatColor.AQUA + this.channelPassword);
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Has Password: " + ChatColor.AQUA + !this.channelPassword.equalsIgnoreCase(""));
        }
        if (this.channelAdmin != null) {
            sender.sendMessage(ChatColor.YELLOW + "ChannelAdmin: " + ChatColor.AQUA + this.channelAdmin);
        }
        int n = isMuted = player == null ? 0 : this.muteContainer.isMuted(racPlayer);
        if (isMuted != -1) {
            sender.sendMessage(ChatColor.YELLOW + "Muted for: " + ChatColor.AQUA + this.getTimeString(isMuted));
        }
        int n2 = isBanned = player == null ? 0 : this.banContainer.isBanned(racPlayer);
        if (isBanned != -1) {
            sender.sendMessage(ChatColor.YELLOW + "Banned for: " + ChatColor.AQUA + this.getTimeString(isBanned));
        }
        sender.sendMessage(ChatColor.YELLOW + "===== Channel Members: =====");
        String memberString = "";
        if (this.channelLevel == ChannelLevel.LocalChannel && sender instanceof Player) {
            this.rescanPartitions((Player)sender);
        }
        for (RaCPlayer member : this.participants) {
            RaCPlayer playerMember = RaCPlayerManager.get().getPlayer(player);
            memberString = playerMember == null || !playerMember.isOnline() ? String.valueOf(memberString) + ChatColor.RED + member + " (offline), " : String.valueOf(memberString) + ChatColor.GREEN + member + ", ";
        }
        if (memberString.length() > 0) {
            sender.sendMessage(memberString.substring(0, memberString.length() - 2));
        } else {
            sender.sendMessage(ChatColor.RED + "This channel has currently no Members.");
        }
    }

    public ChannelLevel getChannelLevel() {
        return this.channelLevel;
    }

    public boolean isMember(RaCPlayer player) {
        return this.participants.contains(player);
    }

    public void tick() {
        this.muteContainer.tick();
        this.banContainer.tick();
    }

    public boolean checkPermissionMute(Player admin) {
        if (this.channelLevel == ChannelLevel.GlobalChannel || this.channelLevel == ChannelLevel.RaceChannel || this.channelLevel == ChannelLevel.WorldChannel || this.channelLevel == ChannelLevel.LocalChannel) {
            return this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)admin, "RaC.chanel.global.mutepower");
        }
        return admin.getUniqueId().equals(this.channelAdmin);
    }

    public boolean checkPermissionUnmute(Player admin) {
        if (this.channelLevel == ChannelLevel.GlobalChannel || this.channelLevel == ChannelLevel.RaceChannel || this.channelLevel == ChannelLevel.WorldChannel || this.channelLevel == ChannelLevel.LocalChannel) {
            return this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)admin, "RaC.chanel.global.unmutepower");
        }
        return admin.getUniqueId().equals(this.channelAdmin);
    }

    public boolean checkPermissionBann(Player admin) {
        if (this.channelLevel == ChannelLevel.GlobalChannel || this.channelLevel == ChannelLevel.RaceChannel || this.channelLevel == ChannelLevel.WorldChannel || this.channelLevel == ChannelLevel.LocalChannel) {
            return this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)admin, "RaC.chanel.global.banpower");
        }
        return admin.getUniqueId().equals(this.channelAdmin);
    }

    public boolean checkPermissionUnban(Player admin) {
        if (this.channelLevel == ChannelLevel.GlobalChannel || this.channelLevel == ChannelLevel.RaceChannel || this.channelLevel == ChannelLevel.WorldChannel || this.channelLevel == ChannelLevel.LocalChannel) {
            return this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)admin, "RaC.chanel.global.unbanpower");
        }
        return admin.getUniqueId().equals(this.channelAdmin);
    }

    public boolean isMuted(RaCPlayer player) {
        return this.muteContainer.isMuted(player) != -1;
    }

    public boolean isBanned(RaCPlayer player) {
        return this.banContainer.isBanned(player) != -1;
    }

    public void editChannel(RaCPlayer player, String property, String newValue) {
        if (!(this.hasChannelAdminPower(player) || this.channelLevel != ChannelLevel.PasswordChannel && this.channelLevel != ChannelLevel.PrivateChannel && this.channelLevel != ChannelLevel.PublicChannel && this.channelLevel != ChannelLevel.LocalChannel || player.equals(this.channelAdmin))) {
            player.sendMessage(ChatColor.RED + "You must be the channel-admin to edit the channel");
            return;
        }
        boolean changed = true;
        String loweredProperty = property.toLowerCase();
        if ("format".equals(loweredProperty)) {
            this.channelFormat.setFormat(newValue);
        } else if ("color".equals(loweredProperty)) {
            this.channelFormat.setColor(newValue);
        } else if ("admin".equals(loweredProperty)) {
            changed = this.changeAdmin(player, newValue);
        } else if ("prefix".equals(loweredProperty)) {
            this.channelFormat.setPrefix(newValue);
        } else if ("suffix".equals(loweredProperty)) {
            this.channelFormat.setSuffix(newValue);
        } else if ("password".equals(loweredProperty)) {
            if (this.channelLevel == ChannelLevel.PasswordChannel) {
                this.channelPassword = newValue;
            }
        } else {
            changed = false;
        }
        if (changed) {
            player.sendMessage(ChatColor.LIGHT_PURPLE + property + ChatColor.GREEN + " was changed to: " + ChatColor.LIGHT_PURPLE + newValue);
        } else {
            player.sendMessage(ChatColor.LIGHT_PURPLE + property + ChatColor.RED + " could not be found or your new Argument is invalid.");
            player.sendMessage(ChatColor.RED + "Valid properties are: " + ChatColor.LIGHT_PURPLE + "format, color, prefix, suffix, admin, password");
        }
    }

    private boolean hasChannelAdminPower(RaCPlayer player) {
        return player == null ? false : player.hasPermission("RaC.chanel.adminpower");
    }

    private boolean changeAdmin(RaCPlayer playerUUID, String newAdmin) {
        if (this.channelLevel == ChannelLevel.PasswordChannel || this.channelLevel == ChannelLevel.PrivateChannel || this.channelLevel == ChannelLevel.PublicChannel) {
            return false;
        }
        RaCPlayer newAdminRaCPlayer = null;
        boolean isFoundInList = false;
        for (RaCPlayer member : this.participants) {
            if (!member.getName().equals(newAdmin)) continue;
            isFoundInList = true;
            newAdminRaCPlayer = member;
            break;
        }
        if (isFoundInList) {
            this.sendMessageInChannel(null, "New Admin of this channel is: " + ChatColor.LIGHT_PURPLE + newAdmin, "");
            this.channelAdmin = newAdminRaCPlayer;
            return true;
        }
        return false;
    }

    public void editEvent(AsyncPlayerChatEvent event) {
        LinkedList<Player> members = new LinkedList<Player>();
        this.rescanPartitions(event.getPlayer());
        for (RaCPlayer member : this.participants) {
            if (member == null || !member.isOnline()) continue;
            members.add(member.getPlayer());
        }
        event.getRecipients().clear();
        event.getRecipients().addAll(members);
        String format = this.channelFormat.getFormat();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(event.getPlayer());
        format = this.channelFormat.format(racPlayer, event.getMessage(), "", false);
        event.setFormat(format);
    }

    public void sendUnformatedMessage(String message) {
        for (RaCPlayer player : this.participants) {
            player.sendMessage(message);
        }
    }
}

