/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.chat.channels.container;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public class BanContainer {
    private final HashMap<RaCPlayer, Integer> banned = new HashMap();

    public BanContainer() {
    }

    public BanContainer(YAMLConfigExtended config, String channelPre) {
        Set<String> bannedPlayers = config.getChildren(String.valueOf(channelPre) + ".banned");
        for (String player : bannedPlayers) {
            try {
                UUID id = UUID.fromString(player);
                RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(id);
                int time = config.getInt(String.valueOf(channelPre) + ".banned." + player);
                this.banned.put(racPlayer, time);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public boolean banPlayer(RaCPlayer player, int time) {
        if (!this.banned.containsKey(player)) {
            this.banned.put(player, time);
            return true;
        }
        return false;
    }

    public boolean unbanPlayer(RaCPlayer player) {
        return this.banned.remove(player) != null;
    }

    public void saveContainer(YAMLConfigExtended config, String channelPre) {
        for (RaCPlayer name : this.banned.keySet()) {
            int time = this.banned.get(name);
            config.set(String.valueOf(channelPre) + ".banned." + name.getUniqueId(), time);
        }
        if (this.banned.keySet().size() == 0) {
            config.set(String.valueOf(channelPre) + ".banned.empty", true);
        }
    }

    public int isBanned(RaCPlayer player) {
        return this.banned.containsKey(player) ? this.banned.get(player) : -1;
    }

    public void tick() {
        for (RaCPlayer name : this.banned.keySet()) {
            int duration = this.banned.get(name);
            if (duration == Integer.MAX_VALUE) continue;
            if (--duration < 0) {
                this.banned.remove(name);
                continue;
            }
            this.banned.put(name, duration);
        }
    }
}

