/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.chat.channels;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.chat.channels.container.ChannelContainer;
import de.tobiyas.racesandclasses.chat.channels.container.ChannelInvalidException;
import de.tobiyas.racesandclasses.chat.channels.container.ChannelTicker;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.chat.ChannelLevel;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChannelManager {
    private RacesAndClasses plugin;
    private Map<String, ChannelContainer> channels;
    private final Map<UUID, String> playerChannelMap = new HashMap<UUID, String>();
    private YAMLConfigExtended config;

    protected ChannelManager(YAMLConfigExtended config) {
        this.config = config;
        this.plugin = RacesAndClasses.getPlugin();
        this.channels = new HashMap<String, ChannelContainer>();
    }

    public ChannelManager() {
        this.plugin = RacesAndClasses.getPlugin();
        this.channels = new HashMap<String, ChannelContainer>();
        this.config = new YAMLConfigExtended(Consts.channelsYML);
    }

    public void init() {
        this.channels.clear();
        ChannelTicker.init();
        this.loadChannelsFromFile();
        this.createSTDChannels();
    }

    private void createSTDChannels() {
        this.registerChannel(ChannelLevel.GlobalChannel, "Global");
        this.registerChannel(ChannelLevel.LocalChannel, "Local");
        for (World world : Bukkit.getWorlds()) {
            this.registerChannel(ChannelLevel.WorldChannel, world.getName());
        }
        for (String race : this.plugin.getRaceManager().listAllVisibleHolders()) {
            if (race.equalsIgnoreCase(Consts.defaultRace)) continue;
            this.registerChannel(ChannelLevel.RaceChannel, race);
        }
    }

    public ChannelContainer registerChannel(ChannelLevel level, String channelName) {
        ChannelContainer container = this.getContainer(channelName);
        if (container != null) {
            return null;
        }
        try {
            container = new ChannelContainer(channelName, level);
            this.channels.put(channelName, container);
            return container;
        }
        catch (ChannelInvalidException exp) {
            return null;
        }
    }

    public boolean registerChannel(ChannelLevel level, String channelName, RaCPlayer player) {
        ChannelContainer container = this.registerChannel(level, channelName);
        if (container == null) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + "Channel: " + ChatColor.AQUA + channelName + ChatColor.RED + " already exists.");
            }
            return false;
        }
        container.addPlayerToChannel(player, "", true);
        return true;
    }

    public boolean registerChannel(ChannelLevel channelLevel, String channelName, String channelPassword, RaCPlayer player) {
        boolean worked = this.registerChannel(channelLevel, channelName, player);
        if (worked) {
            ChannelContainer container = this.getContainer(channelName);
            container.setAdmin(player);
            container.setPassword(channelPassword);
            if (player != null) {
                player.sendMessage(ChatColor.GREEN + "The channel " + ChatColor.AQUA + channelName + ChatColor.GREEN + " has been created successfully");
            }
        }
        return worked;
    }

    private void createStructure() {
        File file = this.config.getFileLoadFrom();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.log("Could not create " + Consts.channelsYML);
                return;
            }
            this.config = new YAMLConfigExtended(Consts.channelsYML).load();
            if (!this.config.contains("channel")) {
                this.config.createSection("channel");
            }
            if (!this.config.contains("channel." + ChannelLevel.PasswordChannel.name())) {
                this.config.createSection("channel." + ChannelLevel.PasswordChannel.name());
            }
            if (!this.config.contains("channel." + ChannelLevel.PrivateChannel.name())) {
                this.config.createSection("channel." + ChannelLevel.PrivateChannel.name());
            }
            if (!this.config.contains("channel." + ChannelLevel.PublicChannel.name())) {
                this.config.createSection("channel." + ChannelLevel.PublicChannel.name());
            }
            this.config.save();
        }
    }

    private void loadChannelsFromFile() {
        this.createStructure();
        this.config.load();
        ChannelLevel[] channelLevelArray = ChannelLevel.values();
        int n = channelLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelLevel level = channelLevelArray[n2];
            for (String channelName : this.config.getChildren("channel." + level.name())) {
                try {
                    ChannelContainer container = ChannelContainer.constructFromYml(this.config, channelName, level);
                    if (container.getChannelLevel() == ChannelLevel.WorldChannel && Bukkit.getWorld((String)container.getChannelName()) == null || container == null) continue;
                    this.channels.put(channelName, container);
                }
                catch (ChannelInvalidException channelInvalidException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void saveChannels() {
        for (String channelName : this.channels.keySet()) {
            ChannelContainer container = this.getContainer(channelName);
            container.saveChannel(this.config);
        }
    }

    public boolean broadcastMessageToChannel(String channel, CommandSender sender, String message) {
        ChannelContainer container = this.getContainer(channel);
        if (container == null) {
            if (sender != null) {
                sender.sendMessage(ChatColor.RED + "Channel " + ChatColor.AQUA + channel + ChatColor.RED + " was not found.");
            }
            return false;
        }
        container.sendMessageInChannel(sender, message, "");
        return true;
    }

    public List<String> listAllChannels() {
        ArrayList<String> channelList = new ArrayList<String>();
        for (String channel : this.channels.keySet()) {
            channelList.add(channel);
        }
        return channelList;
    }

    public List<String> listAllPublicChannels() {
        ArrayList<String> channelList = new ArrayList<String>();
        for (String channel : this.channels.keySet()) {
            ChannelContainer container = this.getContainer(channel);
            ChannelLevel level = container.getChannelLevel();
            if (level == ChannelLevel.PasswordChannel || level == ChannelLevel.PrivateChannel) continue;
            channelList.add(channel);
        }
        return channelList;
    }

    public void postChannelInfo(CommandSender sender, String channel) {
        ChannelContainer container = this.getContainer(channel);
        if (container == null) {
            sender.sendMessage(ChatColor.RED + "Channel " + ChatColor.AQUA + channel + ChatColor.RED + " could not be found.");
            return;
        }
        container.postInfo(sender);
    }

    public ChannelLevel getChannelLevel(String channel) {
        if (channel == null) {
            return ChannelLevel.NONE;
        }
        for (String containerName : this.channels.keySet()) {
            ChannelContainer container;
            if (containerName == null || !(container = this.getContainer(containerName)).getChannelName().equalsIgnoreCase(channel)) continue;
            return container.getChannelLevel();
        }
        return ChannelLevel.NONE;
    }

    public void joinChannel(RaCPlayer player, String channelName, String password, boolean notify) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            return;
        }
        container.addPlayerToChannel(player, password, notify);
    }

    private ChannelContainer getContainer(String channelName) {
        if (channelName == null) {
            return null;
        }
        for (String name : this.channels.keySet()) {
            if (!channelName.equalsIgnoreCase(name)) continue;
            return this.channels.get(name);
        }
        return null;
    }

    public void leaveChannel(RaCPlayer player, String channelName, boolean notify) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            if (notify && player != null) {
                player.sendMessage(ChatColor.RED + "The Channel: " + channelName + " does not exist.");
            }
            return;
        }
        container.removePlayerFromChannel(player, notify);
    }

    public boolean isMember(RaCPlayer player, String channelName) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            return false;
        }
        if (container.getChannelLevel() == ChannelLevel.LocalChannel) {
            return true;
        }
        return container.isMember(player);
    }

    public void mutePlayer(RaCPlayer admin, RaCPlayer mutedRaCPlayer, String channelName, int time) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "Channel not found.");
            }
            return;
        }
        if (!container.checkPermissionMute(admin.getPlayer())) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "You don't have the permission to do this.");
            }
            return;
        }
        if (!container.isMember(mutedRaCPlayer)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "There is no player with this name in this channel.");
            }
            return;
        }
        if (container.isMuted(mutedRaCPlayer)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "The Player is already muted.");
            }
            return;
        }
        container.mutePlayer(mutedRaCPlayer, time);
        this.broadcastMessageToChannel(channelName, null, " Player: " + mutedRaCPlayer + " got muted by: " + admin.getDisplayName());
    }

    public void unmutePlayer(RaCPlayer admin, RaCPlayer unmutedRaCPlayer, String channelName) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "Channel not found.");
            }
            return;
        }
        if (!container.checkPermissionUnmute(admin.getPlayer())) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "You don't have the permission to do this.");
            }
            return;
        }
        if (!container.isMember(unmutedRaCPlayer)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "There is no player with this name in this channel.");
            }
            return;
        }
        if (!container.isMuted(unmutedRaCPlayer)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "No player with this name is muted.");
            }
            return;
        }
        container.unmutePlayer(unmutedRaCPlayer);
        this.broadcastMessageToChannel(channelName, null, " Player: " + unmutedRaCPlayer + " got unmuted by: " + admin.getDisplayName());
    }

    public void banPlayer(RaCPlayer admin, RaCPlayer banName, String channelName, int time) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "Channel not found.");
            }
            return;
        }
        if (!container.checkPermissionBann(admin.getPlayer())) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "You don't have the permission to do this.");
            }
            return;
        }
        if (!container.isMember(banName)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "There is no player with this name in this channel.");
            }
            return;
        }
        if (container.isBanned(banName)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "This Player is already banned from the channel.");
            }
            return;
        }
        this.broadcastMessageToChannel(channelName, null, " Player: " + banName + " got baned from channel by: " + admin.getDisplayName());
        container.banAndRemovePlayer(banName, time);
    }

    public void unbanPlayer(RaCPlayer admin, RaCPlayer unbanRaCPlayer, String channelName) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "Channel not found.");
            }
            return;
        }
        if (!container.checkPermissionMute(admin.getPlayer())) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "You don't have the permission to do this.");
            }
            return;
        }
        if (!container.isBanned(unbanRaCPlayer)) {
            if (admin != null) {
                admin.sendMessage(ChatColor.RED + "No player with this name is banned.");
            }
            return;
        }
        container.unbanPlayer(unbanRaCPlayer);
        if (admin != null) {
            admin.sendMessage(ChatColor.GREEN + "Player: " + ChatColor.LIGHT_PURPLE + unbanRaCPlayer + ChatColor.GREEN + " got unbanned from channel: " + ChatColor.LIGHT_PURPLE + channelName);
        }
        if (unbanRaCPlayer != null) {
            unbanRaCPlayer.sendMessage(ChatColor.GREEN + "You got unbanned from channel: " + ChatColor.LIGHT_PURPLE + channelName);
        }
    }

    public void removeChannel(String channelName) {
        ChannelContainer container = this.getContainer(channelName);
        if (container == null) {
            return;
        }
        ChannelTicker.unregisterChannel(container);
        this.config.load();
        this.config.set("channel." + (Object)((Object)container.getChannelLevel()) + "." + channelName, 1);
        this.config.set("channel." + (Object)((Object)container.getChannelLevel()) + "." + channelName, null);
        this.config.save();
        this.channels.remove(channelName);
    }

    public void playerLogin(RaCPlayer player) {
        this.joinChannel(player, "Global", "", true);
        this.joinChannel(player, player.getWorld().getName(), "", false);
        AbstractTraitHolder container = this.plugin.getRaceManager().getHolderOfPlayer(player);
        if (container != null) {
            this.joinChannel(player, container.getDisplayName(), "", false);
        }
    }

    public void playerQuit(RaCPlayer player) {
        this.leaveChannel(player, "Global", true);
        this.leaveChannel(player, player.getWorld().getName(), false);
        AbstractTraitHolder container = this.plugin.getRaceManager().getHolderOfPlayer(player);
        if (container != null) {
            this.leaveChannel(player, container.getDisplayName(), false);
        }
    }

    public void playerChangedWorld(World oldWorld, RaCPlayer player) {
        World newWorld = player.getWorld();
        boolean notify = this.plugin.getConfigManager().getGeneralConfig().isConfig_disableChatJoinLeaveMessages();
        this.leaveChannel(player, oldWorld.getName(), notify);
        this.joinChannel(player, newWorld.getName(), "", notify);
    }

    public void playerLeaveRace(String oldRace, RaCPlayer player) {
        if (player == null) {
            return;
        }
        AbstractTraitHolder container = this.plugin.getRaceManager().getHolderByName(oldRace);
        if (container == null) {
            return;
        }
        String raceToLeave = container.getDisplayName();
        this.leaveChannel(player, raceToLeave, true);
    }

    public void playerJoinRace(String newRace, RaCPlayer player) {
        if (player == null) {
            return;
        }
        AbstractTraitHolder container = this.plugin.getRaceManager().getHolderByName(newRace);
        if (container == null) {
            return;
        }
        String raceToLeave = container.getDisplayName();
        this.joinChannel(player, raceToLeave, "", true);
    }

    public void editChannel(RaCPlayer player, String channel, String property, String newValue) {
        ChannelContainer container = this.getContainer(channel);
        if (container == null) {
            return;
        }
        container.editChannel(player, property, newValue);
    }

    public void editToChannel(String channel, AsyncPlayerChatEvent event) {
        String format = event.getFormat();
        if (format.contains("%1$s") && format.contains("%2$s")) {
            Player sender = event.getPlayer();
            ChannelContainer container = this.getContainer(channel);
            if (container == null) {
                if (sender != null) {
                    sender.sendMessage(ChatColor.RED + "Channel " + ChatColor.AQUA + channel + ChatColor.RED + " was not found.");
                    event.setCancelled(true);
                }
                return;
            }
            container.editEvent(event);
        }
    }

    public void deleteChannel(RaCPlayer deleter, String channel) {
        ChannelContainer container = this.getContainer(channel);
        if (container.getAdmin() != deleter || !this.plugin.getPermissionManager().checkPermissions((CommandSender)deleter.getPlayer(), "RaC.channel.delete")) {
            return;
        }
        container.sendUnformatedMessage(ChatColor.YELLOW + "Channel " + container.getChannelName() + " was deleted.");
        this.removeChannel(container.getChannelName());
    }

    public String getCurrentChannel(RaCPlayer player) {
        if (!this.playerChannelMap.containsKey(player.getUniqueId())) {
            this.playerChannelMap.put(player.getUniqueId(), "Global");
        }
        return this.playerChannelMap.get(player.getUniqueId());
    }

    public void changeCurrentChannel(RaCPlayer player, String channel) {
        this.playerChannelMap.put(player.getUniqueId(), channel);
    }
}

