/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.chat;

import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.chat.ChannelLevel;
import org.bukkit.ChatColor;

public class ChatFormatter {
    private String format = "";
    private ChannelLevel level = ChannelLevel.NONE;
    private String name = "";
    private String color = "&c";
    private String prefix = "&f[";
    private String suffix = "&f]";

    public ChatFormatter() {
    }

    public ChatFormatter(String name, String color, ChannelLevel level, String format) {
        this.name = name;
        this.color = color;
        this.level = level;
        this.format = format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public String format(RaCPlayer player, String msg, String forceFormat, boolean replaceMessage) {
        String level;
        String world;
        String realName;
        String displayName;
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        AbstractTraitHolder raceContainer = plugin.getRaceManager().getHolderOfPlayer(player);
        AbstractTraitHolder classContainer = plugin.getClassManager().getHolderOfPlayer(player);
        if (player == null) {
            displayName = "CONSOLE";
            realName = "CONSOLE";
            world = "None";
            level = "";
        } else {
            displayName = player.getDisplayName();
            realName = player.getName();
            world = player.getWorld().getName();
            level = String.valueOf(LevelAPI.getCurrentLevel(player));
        }
        String messageFormat = "";
        messageFormat = forceFormat.equals("") ? new String(this.format) : new String(forceFormat);
        String raceTag = raceContainer == null ? "NONE" : raceContainer.getTag();
        String classTag = classContainer == null ? "" : classContainer.getTag();
        messageFormat = messageFormat.replace("{color}", this.color);
        messageFormat = messageFormat.replace("{nick}", this.name);
        messageFormat = messageFormat.replace("{prefix}", this.prefix);
        messageFormat = messageFormat.replace("{suffix}", this.suffix);
        messageFormat = messageFormat.replace("{sender}", displayName);
        messageFormat = messageFormat.replace("{realname}", realName);
        messageFormat = messageFormat.replace("{race}", raceTag);
        messageFormat = messageFormat.replace("{class}", classTag);
        messageFormat = messageFormat.replace("{world}", world);
        messageFormat = messageFormat.replace("{level}", level);
        messageFormat = messageFormat.replace("{channeltype}", this.level.name());
        messageFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)messageFormat);
        if (replaceMessage) {
            msg = msg.replace("{msg}", "").replaceAll("%2$s", "");
            messageFormat = messageFormat.replace("{msg}", msg);
            messageFormat = messageFormat.replace("%2$s", msg);
        }
        return messageFormat;
    }

    public ChannelLevel getLevel() {
        return this.level;
    }

    public void setLevel(ChannelLevel level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

