/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.spawning;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.addins.spawning.RaceSpawn;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;

public class RaceSpawnManager {
    private final Set<RaceSpawn> spawns = new HashSet<RaceSpawn>();
    private final File saveDir;
    private final File saveFile;
    private final YAMLConfigExtended config;

    public RaceSpawnManager(RacesAndClasses plugin) {
        File addinFolder = new File(plugin.getDataFolder(), "addins");
        this.saveDir = new File(addinFolder, "spawns");
        this.saveFile = new File(this.saveDir, "spawns.yml");
        if (!addinFolder.exists()) {
            addinFolder.mkdirs();
        }
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
        if (!this.saveFile.exists()) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.config = new YAMLConfigExtended(this.saveFile);
    }

    public void load() {
        this.spawns.clear();
        this.config.load();
        for (String rootChild : this.config.getRootChildren()) {
            Location spawnLoc = this.config.getLocation(String.valueOf(rootChild) + ".spawn");
            String race = this.config.getString(String.valueOf(rootChild) + ".race");
            if (spawnLoc == null || race == null) continue;
            RaceSpawn spawn = new RaceSpawn(race, spawnLoc);
            this.spawns.add(spawn);
        }
    }

    public void save(boolean async) {
        this.config.clearConfig();
        for (RaceSpawn spawn : this.spawns) {
            String race = spawn.getRace();
            Location loc = spawn.getSpawnLocation();
            this.config.set(String.valueOf(race) + ".race", race);
            this.config.set(String.valueOf(race) + ".spawn", loc);
        }
        if (async) {
            this.config.saveAsync();
        } else {
            this.config.save();
        }
    }

    public void setRaceSpawn(String race, Location loc) {
        if (race == null || loc == null) {
            return;
        }
        for (RaceSpawn spawn : this.spawns) {
            if (!spawn.getRace().equalsIgnoreCase(race)) continue;
            this.spawns.remove(spawn);
            break;
        }
        this.spawns.add(new RaceSpawn(race, loc));
    }

    public Location getSpawnForRace(String race) {
        for (RaceSpawn spawn : this.spawns) {
            if (!spawn.getRace().equalsIgnoreCase(race)) continue;
            return spawn.getSpawnLocation();
        }
        return null;
    }
}

