/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.potions;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class ManaPotionManager
implements Listener {
    private final int MANA_POTION_COOLDOWN = 200;
    private final RacesAndClasses plugin;
    private final List<String> MANA_POTION_NAMES = Arrays.asList("ManaPotion", "ManaTrank");
    private final Set<UUID> cooldown = new HashSet<UUID>();

    public ManaPotionManager(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.cooldown.clear();
        HandlerList.unregisterAll((Listener)this);
        this.plugin.registerEvents(this);
    }

    @EventHandler
    public void manaPotionUsed(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        if (!item.getItemMeta().hasDisplayName()) {
            return;
        }
        if (!item.getItemMeta().hasLore()) {
            return;
        }
        if (item.getItemMeta().getLore().size() < 1) {
            return;
        }
        String itemName = item.getItemMeta().getDisplayName().toLowerCase();
        itemName = ChatColor.stripColor((String)itemName.toLowerCase()).replace(" ", "");
        boolean found = false;
        for (String name : this.MANA_POTION_NAMES) {
            if (!itemName.contains(name = name.toLowerCase())) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        int mana = 0;
        int minLevel = 0;
        for (String loreLine : item.getItemMeta().getLore()) {
            if (!(loreLine = ChatColor.stripColor((String)loreLine.toLowerCase())).contains(" mana")) {
                String manaLine = loreLine.replaceAll("[^0-9]", "");
                try {
                    mana = Integer.parseInt(manaLine);
                }
                catch (NumberFormatException exp) {
                    continue;
                }
            }
            if (loreLine.contains("level")) continue;
            String levelLine = loreLine.replaceAll("[^0-9]", "");
            try {
                minLevel = Integer.parseInt(levelLine);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (mana <= 0) {
            return;
        }
        event.setCancelled(true);
        final RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (minLevel > 0 && LevelAPI.getCurrentLevel(racPlayer) < minLevel) {
            LanguageAPI.sendTranslatedMessage((CommandSender)event.getPlayer(), "restrictions_not_met_MinimumLevel");
            return;
        }
        if (racPlayer.getManaManager().isManaFull()) {
            LanguageAPI.sendTranslatedMessage((CommandSender)event.getPlayer(), "alread_full_mana");
            return;
        }
        racPlayer.getManaManager().fillMana(mana);
        this.cooldown.add(racPlayer.getUniqueId());
        if (item.getAmount() == 1) {
            event.getPlayer().getInventory().remove(item);
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        }
        new DebugBukkitRunnable("ManaPotionCooldownRemover"){

            @Override
            protected void runIntern() {
                ManaPotionManager.this.cooldown.remove(racPlayer.getUniqueId());
            }
        }.runTaskLater((Plugin)RacesAndClasses.getPlugin(), 200L);
        event.getPlayer().getWorld().playEffect(event.getPlayer().getLocation(), Effect.POTION_BREAK, (Object)new Potion(PotionType.WATER));
    }
}

