/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.potions;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.health.HealthManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class HealthPotionManager
implements Listener {
    private final int HEALTH_POTION_COOLDOWN = 200;
    private final RacesAndClasses plugin;
    private final List<String> HEALTH_POTION_NAMES = Arrays.asList("HealingPotion", "HeilTrank");
    private final Set<UUID> cooldown = new HashSet<UUID>();

    public HealthPotionManager(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.cooldown.clear();
        HandlerList.unregisterAll((Listener)this);
        this.plugin.registerEvents(this);
    }

    @EventHandler
    public void healthPotionUsed(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        if (!item.getItemMeta().hasDisplayName()) {
            return;
        }
        if (!item.getItemMeta().hasLore()) {
            return;
        }
        if (item.getItemMeta().getLore().size() < 1) {
            return;
        }
        String itemName = item.getItemMeta().getDisplayName().toLowerCase();
        itemName = ChatColor.stripColor((String)itemName.toLowerCase());
        boolean found = false;
        for (String name : this.HEALTH_POTION_NAMES) {
            if (!itemName.contains(name = name.toLowerCase())) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        int health = 0;
        int minLevel = 0;
        for (String loreLine : item.getItemMeta().getLore()) {
            if ((loreLine = ChatColor.stripColor((String)loreLine.toLowerCase())).contains("health") || loreLine.contains("leben")) {
                String manaLine = loreLine.replaceAll("[^0-9]", "");
                try {
                    health = Integer.parseInt(manaLine);
                }
                catch (NumberFormatException exp) {
                    continue;
                }
            }
            if (loreLine.contains("level")) continue;
            String levelLine = loreLine.replaceAll("[^0-9]", "");
            try {
                minLevel = Integer.parseInt(levelLine);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (health <= 0) {
            return;
        }
        event.setCancelled(true);
        final RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (minLevel > 0 && LevelAPI.getCurrentLevel(racPlayer) < minLevel) {
            LanguageAPI.sendTranslatedMessage((CommandSender)event.getPlayer(), "restrictions_not_met_MinimumLevel");
            return;
        }
        HealthManager healthManager = racPlayer.getHealthManager();
        if (healthManager.getCurrentHealth() >= healthManager.getMaxHealth()) {
            LanguageAPI.sendTranslatedMessage((CommandSender)event.getPlayer(), "health_full");
            return;
        }
        healthManager.heal(health);
        this.cooldown.add(racPlayer.getUniqueId());
        if (item.getAmount() == 1) {
            event.getPlayer().getInventory().remove(item);
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        }
        new DebugBukkitRunnable("HealthPotionCooldownRemover"){

            @Override
            protected void runIntern() {
                HealthPotionManager.this.cooldown.remove(racPlayer.getUniqueId());
            }
        }.runTaskLater((Plugin)RacesAndClasses.getPlugin(), 200L);
        event.getPlayer().getWorld().playEffect(event.getPlayer().getLocation(), Effect.POTION_BREAK, (Object)new Potion(PotionType.WATER));
    }
}

