/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.placeholderapisupport;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.addins.placeholderapisupport.ClipRaCPlaceholderReplacer;
import de.tobiyas.racesandclasses.addins.placeholderapisupport.MVdWRaCPlaceholderReplacer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;

public class PlaceholderAPISupportManager
implements Listener {
    private static final String MVdW_PLUGIN_NAME = "MVdWPlaceholderAPI";
    private static final String CLIP_PLUGIN_NAME = "PlaceholderAPI";
    private final RacesAndClasses plugin;

    public PlaceholderAPISupportManager(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        HandlerList.unregisterAll((Listener)this);
        this.plugin.registerEvents(this);
        if (Bukkit.getPluginManager().isPluginEnabled(MVdW_PLUGIN_NAME)) {
            this.registerMVdWReplacer();
        }
        if (Bukkit.getPluginManager().isPluginEnabled(CLIP_PLUGIN_NAME)) {
            this.registerClipReplacer();
        }
    }

    @EventHandler
    public void onPluginLoad(PluginEnableEvent event) {
        if (event.getPlugin().getName().equalsIgnoreCase(MVdW_PLUGIN_NAME)) {
            this.registerMVdWReplacer();
        }
        if (event.getPlugin().getName().equalsIgnoreCase(CLIP_PLUGIN_NAME)) {
            this.registerClipReplacer();
        }
    }

    private void registerMVdWReplacer() {
        MVdWRaCPlaceholderReplacer replacer = new MVdWRaCPlaceholderReplacer(this.plugin);
        replacer.register();
    }

    private void registerClipReplacer() {
        ClipRaCPlaceholderReplacer replacer = new ClipRaCPlaceholderReplacer(this.plugin);
        replacer.register();
    }

    public String replace(Player player, String toReplace) {
        if (Bukkit.getPluginManager().isPluginEnabled(MVdW_PLUGIN_NAME)) {
            toReplace = MVdWRaCPlaceholderReplacer.replace(player, toReplace);
        }
        if (Bukkit.getPluginManager().isPluginEnabled(CLIP_PLUGIN_NAME)) {
            toReplace = ClipRaCPlaceholderReplacer.replace(player, toReplace);
        }
        return toReplace;
    }
}

