/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.placeholderapisupport;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import be.maximvdw.placeholderapi.PlaceholderReplaceEvent;
import be.maximvdw.placeholderapi.PlaceholderReplacer;
import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.APIs.ManaAPI;
import de.tobiyas.racesandclasses.APIs.RaceAPI;
import de.tobiyas.racesandclasses.APIs.SpellAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.util.RaC.formating.ParseUtils;
import java.text.DecimalFormat;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MVdWRaCPlaceholderReplacer
implements PlaceholderReplacer {
    private static final String BATTLE_LINE = "racBattleLine".toLowerCase();
    private final RacesAndClasses plugin;
    private final DecimalFormat format = new DecimalFormat("0.0");

    public MVdWRaCPlaceholderReplacer(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public String onPlaceholderReplace(PlaceholderReplaceEvent event) {
        String numString;
        int num;
        String placeholder = event.getPlaceholder().toLowerCase();
        Player player = event.getPlayer();
        if (placeholder.equals("race")) {
            return RaceAPI.getRaceNameOfPlayer(player);
        }
        if (placeholder.equals("class")) {
            return ClassAPI.getClassNameOfPlayer(player);
        }
        if (placeholder.equals("mana")) {
            return this.format.format(ManaAPI.getCurrentMana(player));
        }
        if (placeholder.equals("maxmana")) {
            return this.format.format(ManaAPI.getMaxMana(player));
        }
        if (placeholder.equals("level")) {
            return String.valueOf(LevelAPI.getCurrentLevel(player));
        }
        if (placeholder.equals("exp")) {
            return this.format.format(LevelAPI.getCurrentExpOfLevel(player));
        }
        if (placeholder.equals("maxexp")) {
            return this.format.format(LevelAPI.getMaxEXPToNextLevel(player));
        }
        if (placeholder.equals("currentspell")) {
            return SpellAPI.getCurrentSelectedSpellName(player);
        }
        if (placeholder.equals("currentspellcost")) {
            return this.format.format(SpellAPI.getCurrentSpellCost(player));
        }
        if (placeholder.equals("currentspellcosttype")) {
            return SpellAPI.getCurrentSelectedSpellCostName(player);
        }
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (placeholder.equalsIgnoreCase("currentarrow")) {
            return racPlayer.getArrowManager().getCurrentArrow().getDisplayName();
        }
        if (placeholder.equalsIgnoreCase("currentarrowcost")) {
            return this.format.format(racPlayer.getArrowManager().getCurrentArrow().getCost(racPlayer));
        }
        if (placeholder.equalsIgnoreCase("currentarrowcostname")) {
            return racPlayer.getArrowManager().getCurrentArrow().getCostType().name();
        }
        if (placeholder.startsWith(BATTLE_LINE) && (num = ParseUtils.parseInt(numString = placeholder.substring(BATTLE_LINE.length()), -1)) >= 0 && num <= 15) {
            return this.battleLine(racPlayer, num);
        }
        return null;
    }

    public void register() {
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"race", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"class", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"mana", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"maxmana", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"level", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"exp", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"maxexp", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"currentspell", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"currentspellcost", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"currentspellcosttype", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"currentarrow", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"currentarrowcost", (PlaceholderReplacer)this);
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)"currentarrowcostname", (PlaceholderReplacer)this);
        int i = 0;
        while (i < 16) {
            PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)(String.valueOf(BATTLE_LINE) + i), (PlaceholderReplacer)this);
            ++i;
        }
    }

    public void unregister() {
    }

    private String battleLine(RaCPlayer player, int line) {
        PlayerRaCScoreboardManager manager = player.getScoreboardManager();
        PlayerRaCScoreboardManager.SBCategory category = manager.getSelectedCategory();
        try {
            if (category == PlayerRaCScoreboardManager.SBCategory.Arrows) {
                return manager.getKeyForValue(category, line);
            }
            if (category == PlayerRaCScoreboardManager.SBCategory.Spells) {
                return manager.getKeyForValue(category, line);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public static String replace(Player player, String toReplace) {
        return PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)toReplace);
    }
}

