/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.placeholderapisupport;

import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.APIs.ManaAPI;
import de.tobiyas.racesandclasses.APIs.RaceAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import java.text.DecimalFormat;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClipRaCPlaceholderReplacer
extends PlaceholderHook {
    private final RacesAndClasses plugin;
    private final DecimalFormat format = new DecimalFormat("0.0");

    public ClipRaCPlaceholderReplacer(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public void register() {
        PlaceholderAPI.registerPlaceholderHook((Plugin)this.plugin, (PlaceholderHook)this);
    }

    public void unregister() {
        PlaceholderAPI.unregisterPlaceholderHook((Plugin)this.plugin);
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier.equalsIgnoreCase("race")) {
            return RaceAPI.getRaceNameOfPlayer(player);
        }
        if (identifier.equalsIgnoreCase("class")) {
            return ClassAPI.getClassNameOfPlayer(player);
        }
        if (identifier.equalsIgnoreCase("mana")) {
            return this.format.format(ManaAPI.getCurrentMana(player));
        }
        if (identifier.equalsIgnoreCase("maxmana")) {
            return this.format.format(ManaAPI.getMaxMana(player));
        }
        if (identifier.equalsIgnoreCase("level")) {
            return String.valueOf(LevelAPI.getCurrentLevel(player));
        }
        if (identifier.equalsIgnoreCase("exp")) {
            return this.format.format(LevelAPI.getCurrentExpOfLevel(player));
        }
        if (identifier.equalsIgnoreCase("maxexp")) {
            return this.format.format(LevelAPI.getMaxEXPToNextLevel(player));
        }
        return null;
    }

    public static String replace(Player player, String toReplace) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)toReplace);
    }
}

