/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.groups.impl;

import de.tobiyas.racesandclasses.addins.groups.GroupManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class OwnGroupManager
implements GroupManager {
    private Set<OwnGroup> groups = new HashSet<OwnGroup>();

    @Override
    public boolean isInSameGroup(Player player1, Player player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        OwnGroup g1 = this.getGroup(player1.getUniqueId());
        OwnGroup g2 = this.getGroup(player2.getUniqueId());
        return g1 != null && g2 != null && g1 == g2;
    }

    @Override
    public boolean hasGroup(Player player) {
        if (player == null) {
            return false;
        }
        return this.getGroup(player.getUniqueId()) != null;
    }

    @Override
    public boolean addPlayerToGroup(Player groupOwner, Player toAdd) {
        if (groupOwner == null || toAdd == null) {
            return false;
        }
        UUID owner = groupOwner.getUniqueId();
        OwnGroup group = this.getGroup(owner);
        if (group == null) {
            group = new OwnGroup(owner);
            this.groups.add(group);
        }
        this.playerLeavesGroup(toAdd);
        if (group.getOwner() != groupOwner.getUniqueId()) {
            return false;
        }
        group.addMember(toAdd.getUniqueId());
        return true;
    }

    @Override
    public boolean playerLeavesGroup(Player player) {
        if (player == null) {
            return false;
        }
        UUID id = player.getUniqueId();
        OwnGroup group = this.getGroup(id);
        if (group == null) {
            return false;
        }
        group.remove(id);
        if (group.isEmpty()) {
            this.groups.remove(group);
        }
        return true;
    }

    @Override
    public Collection<Player> getMembersOfGroup(Player player) {
        if (player == null) {
            return new HashSet<Player>();
        }
        OwnGroup group = this.getGroup(player.getUniqueId());
        HashSet<Player> members = new HashSet<Player>();
        if (group == null) {
            return members;
        }
        for (UUID id : group.members()) {
            Player pl = Bukkit.getPlayer((UUID)id);
            if (pl == null) continue;
            members.add(pl);
        }
        return members;
    }

    @Override
    public Player getLeaderOfGroup(Player player) {
        if (player == null) {
            return null;
        }
        OwnGroup group = this.getGroup(player.getUniqueId());
        if (group == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)group.getOwner());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void deinit() {
        this.groups.clear();
    }

    private OwnGroup getGroup(UUID id) {
        if (id == null) {
            return null;
        }
        for (OwnGroup group : this.groups) {
            if (!group.members.contains(id)) continue;
            return group;
        }
        return null;
    }

    private class OwnGroup {
        private final Set<UUID> members = new HashSet<UUID>();
        private UUID owner;

        public OwnGroup(UUID owner) {
            this.owner = owner;
            this.addMember(owner);
        }

        public void addMember(UUID id) {
            this.members.add(id);
        }

        public void remove(UUID id) {
            this.members.remove(id);
            if (this.members.size() > 0 && this.owner == id) {
                this.owner = this.members.iterator().next();
            }
        }

        public Set<UUID> members() {
            return this.members;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public boolean isEmpty() {
            return this.members.isEmpty();
        }
    }
}

