/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.groups.impl;

import com.gmail.nossr50.api.PartyAPI;
import com.gmail.nossr50.datatypes.party.Party;
import de.tobiyas.racesandclasses.addins.groups.GroupManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class McMMOGroupManager
implements GroupManager {
    @Override
    public boolean isInSameGroup(Player player1, Player player2) {
        Party party1 = this.getParty(player1);
        Party party2 = this.getParty(player2);
        return party1 != null && party2 != null && party1 == party2;
    }

    @Override
    public boolean hasGroup(Player player) {
        return this.getParty(player) != null;
    }

    @Override
    public boolean addPlayerToGroup(Player groupOwner, Player toAdd) {
        Party party = this.getParty(groupOwner);
        if (party == null) {
            return false;
        }
        party.addOnlineMember(toAdd);
        return true;
    }

    @Override
    public boolean playerLeavesGroup(Player player) {
        Party party = this.getParty(player);
        if (party == null) {
            return false;
        }
        party.removeOnlineMember(player);
        return true;
    }

    @Override
    public Collection<Player> getMembersOfGroup(Player player) {
        Party party = this.getParty(player);
        return party == null ? new HashSet() : party.getOnlineMembers();
    }

    @Override
    public Player getLeaderOfGroup(Player player) {
        Party party = this.getParty(player);
        return party == null ? null : Bukkit.getPlayer((UUID)party.getLeader().getUniqueId());
    }

    @Override
    public boolean isEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled("McMMO");
    }

    @Override
    public void deinit() {
    }

    private Party getParty(Player player) {
        for (Party party : PartyAPI.getParties()) {
            if (!party.getOnlineMembers().contains(player)) continue;
            return party;
        }
        return null;
    }
}

