/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.addins.food;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.addins.food.Food;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class FoodManager
implements Listener {
    private final RacesAndClasses plugin;
    private final Map<RaCPlayer, Food> eating = new HashMap<RaCPlayer, Food>();
    private BukkitTask task;

    public FoodManager(RacesAndClasses plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null) {
            this.task.cancel();
        }
        this.eating.clear();
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_food_enabled()) {
            return;
        }
        this.plugin.registerEvents(this);
        this.task = new DebugBukkitRunnable("FoodListenerEating"){

            @Override
            protected void runIntern() {
                Iterator it = FoodManager.this.eating.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    RaCPlayer player = (RaCPlayer)entry.getKey();
                    if (!player.isOnline()) {
                        it.remove();
                        continue;
                    }
                    Food food = (Food)entry.getValue();
                    food.tick(player);
                    if (food.isValid()) continue;
                    LanguageAPI.sendTranslatedMessage(player, "food_finished");
                    it.remove();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (this.eating.containsKey(player)) {
            return;
        }
        if (event.getPlayer().getVelocity().length() > 0.1) {
            return;
        }
        if (this.eating.containsKey(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Food food = new Food(item);
        if (food.isValid()) {
            event.setCancelled(true);
            if (player.getHealth() >= player.getMaxHealth()) {
                LanguageAPI.sendTranslatedMessage(player, "health_full");
                return;
            }
            item.setAmount(item.getAmount() - 1);
            player.getPlayer().setItemInHand(item);
            this.eating.put(player, food);
            LanguageAPI.sendTranslatedMessage(player, "food_eat");
        }
    }

    @EventHandler
    public void playerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (!this.eating.containsKey(player)) {
            return;
        }
        this.eating.remove(player);
        LanguageAPI.sendTranslatedMessage(player, "food_cancle");
    }
}

