/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses;

import de.tobiyas.racesandclasses.addins.AddinManager;
import de.tobiyas.racesandclasses.chat.channels.ChannelManager;
import de.tobiyas.racesandclasses.commands.CommandRegisterer;
import de.tobiyas.racesandclasses.configuration.ConfigManager;
import de.tobiyas.racesandclasses.cooldown.CooldownManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.loadingerrors.TraitHolderLoadingErrorHandler;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceManager;
import de.tobiyas.racesandclasses.entitystatusmanager.buffs.BuffManager;
import de.tobiyas.racesandclasses.entitystatusmanager.debuff.DebuffManager;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotManager;
import de.tobiyas.racesandclasses.entitystatusmanager.hots.HotsManager;
import de.tobiyas.racesandclasses.entitystatusmanager.silence.SilenceAndKickManager;
import de.tobiyas.racesandclasses.entitystatusmanager.stun.StunManager;
import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import de.tobiyas.racesandclasses.hotkeys.HotkeyManager;
import de.tobiyas.racesandclasses.infight.InFightManager;
import de.tobiyas.racesandclasses.listeners.RaCListenerRegister;
import de.tobiyas.racesandclasses.playermanagement.PlayerManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerScoreboardUpdater;
import de.tobiyas.racesandclasses.playermanagement.spellmanagement.mana.ManaXPBarRunner;
import de.tobiyas.racesandclasses.saving.PlayerSavingManager;
import de.tobiyas.racesandclasses.saving.dataconverter.PlayerDataConverter;
import de.tobiyas.racesandclasses.statistics.StartupStatisticCategory;
import de.tobiyas.racesandclasses.statistics.StatisticGatherer;
import de.tobiyas.racesandclasses.traitcontainer.TraitStore;
import de.tobiyas.racesandclasses.traitcontainer.container.TraitsList;
import de.tobiyas.racesandclasses.translation.TranslationManagerHolder;
import de.tobiyas.racesandclasses.util.bukkit.versioning.BukkitVersion;
import de.tobiyas.racesandclasses.util.bukkit.versioning.BukkitVersionBuilder;
import de.tobiyas.racesandclasses.util.permissions.VaultHookProvider;
import de.tobiyas.racesandclasses.util.traitutil.DefaultTraitCopy;
import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.metrics.SendMetrics;
import de.tobiyas.util.RaC.vollotile.helper.PermanentActionBarMessages;
import java.io.File;
import net.gravitydevelopment.updater.Updater;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class RacesAndClasses
extends UtilsUsingPlugin
implements Listener {
    public boolean testingMode = false;
    protected PluginDescriptionFile description;
    protected String prefix;
    protected ConfigManager configManager;
    protected PlayerManager playerManager;
    protected CooldownManager cooldownManager;
    protected static RacesAndClasses plugin;
    protected boolean errored = false;
    protected StatisticGatherer statistics;
    protected RaceManager raceManager;
    protected ClassManager classManager;
    protected ChannelManager channelManager;
    protected StunManager stunManager;
    protected DotManager dotManager;
    protected BuffManager buffManager;
    protected DebuffManager debuffManager;
    protected HotkeyManager hotkeyManger;
    protected HotsManager hotsManager;
    protected SilenceAndKickManager silenceAndKickManager;
    protected InFightManager inFightManager;
    protected AddinManager addinManager;
    private static boolean isInShutdown;

    static {
        isInShutdown = false;
    }

    public RacesAndClasses() {
    }

    protected RacesAndClasses(PluginDescriptionFile description, File dataFolder) {
        super(Bukkit.getServer(), null, description, dataFolder, null);
    }

    @Override
    public void pluginEnable() {
        isInShutdown = false;
        this.statistics = new StatisticGatherer(System.currentTimeMillis());
        if (!RacesAndClasses.isVaultPresent()) {
            this.getLogger().warning("RacesAndClasses WARNING:  Plugin Vault is not found! Please download it!");
        }
        CommandRegisterer commandRegister = new CommandRegisterer(this);
        try {
            plugin = this;
            this.getDebugLogger().enable();
            this.getDebugLogger().setAlsoToPlugin(true);
            VaultHookProvider.init(this);
            this.description = this.getDescription();
            this.prefix = "[" + this.description.getName() + "] ";
            this.getDebugLogger().setAlsoToPlugin(true);
            this.checkIfCBVersionGreaterRequired();
            this.fullReload(false, false);
            commandRegister.registerCommands();
            this.initMetrics();
            this.loadingDoneMessage();
        }
        catch (Exception e) {
            this.log("An Error has occured during startup sequence: " + e.getLocalizedMessage());
            this.getDebugLogger().logStackTrace(e);
            this.errored = true;
            commandRegister.registerAllCommandsAsError();
        }
    }

    @Override
    protected void firstTick() {
        super.firstTick();
        this.registerEvents();
        this.registerTasks();
        if (RacesAndClasses.isVaultPresent()) {
            VaultHookProvider.init(this);
        }
    }

    private void registerTasks() {
        new ManaXPBarRunner().start();
    }

    private void checkIfCBVersionGreaterRequired() {
        BukkitVersion version = BukkitVersionBuilder.getbukkitBuildNumber();
        if (version.getBukkitMainVersion() < 1 && version.getBukkitSubVersion() < 6 && version.getBukkitSubSubVersion() < 2) {
            this.log("Bukkit Version is below 1.6. Compatibility mode is used. Double values will be rounded.");
        }
    }

    private void initManagers() {
        long currentTime = System.currentTimeMillis();
        this.setupConfiguration();
        PlayerDataConverter.checkForConvertAndConvert();
        PlayerSavingManager.reload();
        StartupStatisticCategory.ConfigTotal.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        DefaultTraitCopy.removeOldDefaultTraits();
        TraitEventManager traitEventManager = new TraitEventManager();
        if (this.raceManager == null) {
            this.raceManager = new RaceManager();
        }
        if (this.classManager == null) {
            this.classManager = new ClassManager();
        }
        if (this.playerManager == null) {
            this.playerManager = new PlayerManager();
        }
        if (this.channelManager == null) {
            this.channelManager = new ChannelManager();
        }
        if (this.cooldownManager == null) {
            this.cooldownManager = new CooldownManager();
        }
        if (this.stunManager == null) {
            this.stunManager = new StunManager();
        }
        if (this.buffManager == null) {
            this.buffManager = new BuffManager();
        }
        if (this.dotManager == null) {
            this.dotManager = new DotManager();
        }
        if (this.hotsManager == null) {
            this.hotsManager = new HotsManager();
        }
        if (this.silenceAndKickManager == null) {
            this.silenceAndKickManager = new SilenceAndKickManager();
        }
        if (this.hotkeyManger == null) {
            this.hotkeyManger = new HotkeyManager();
        }
        if (this.inFightManager == null) {
            this.inFightManager = new InFightManager();
        }
        if (this.debuffManager == null) {
            this.debuffManager = new DebuffManager();
        }
        if (this.addinManager == null) {
            this.addinManager = new AddinManager(this);
        }
        StartupStatisticCategory.ManagerConstructor.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        this.cooldownManager.init();
        StartupStatisticCategory.CooldownManager.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        traitEventManager.init();
        StartupStatisticCategory.TraitManager.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        if (plugin.getConfigManager().getGeneralConfig().isConfig_enableRaces()) {
            this.raceManager.init();
        }
        StartupStatisticCategory.RaceManager.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        if (this.configManager.getGeneralConfig().isConfig_classes_enable()) {
            this.classManager.init();
        }
        StartupStatisticCategory.ClassManager.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        this.playerManager.init();
        StartupStatisticCategory.PlayerManager.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        currentTime = System.currentTimeMillis();
        if (this.configManager.getGeneralConfig().isConfig_channels_enable()) {
            this.channelManager.init();
        }
        StartupStatisticCategory.ChannelManager.timeInMiliSeconds = System.currentTimeMillis() - currentTime;
        this.stunManager.init();
        this.dotManager.init();
        this.buffManager.init();
        this.debuffManager.init();
        this.inFightManager.reload();
        this.addinManager.reload();
        PlayerScoreboardUpdater.start();
        TranslationManagerHolder.init();
    }

    private void initMetrics() {
        if (this.configManager.getGeneralConfig().isConfig_metrics_enabled()) {
            SendMetrics.sendMetrics((Plugin)this, this.configManager.getGeneralConfig().isConfig_enableDebugOutputs());
        }
    }

    public void onDisable() {
        isInShutdown = true;
        if (!this.errored) {
            this.shutDownSequenz(false);
            VaultHookProvider.shutdown();
        }
        BasicSelectionInterface.closeAllInvs();
        plugin = null;
        this.log("disabled " + this.description.getFullName());
    }

    private void registerEvents() {
        RaCListenerRegister.registerCustoms();
        RaCListenerRegister.registerProxys();
        RaCListenerRegister.registerGeneral();
        RaCListenerRegister.registerChatListeners();
    }

    private void loadingDoneMessage() {
        if (TraitHolderLoadingErrorHandler.evalAndSave()) {
            this.log("There where errors in the races.yml or classes.yml. Look into 'HolderStartupErrors.log' for more infos.");
        }
        String traits = String.valueOf(TraitsList.getAllVisibleTraits().size()) + " traits";
        String races = ", " + plugin.getRaceManager().listAllVisibleHolders().size() + " races";
        String classes = "";
        if (this.configManager.getGeneralConfig().isConfig_classes_enable()) {
            classes = ", " + plugin.getClassManager().getAllHolderNames().size() + " classes";
        }
        String channels = "";
        if (this.configManager.getGeneralConfig().isConfig_channels_enable()) {
            channels = ", " + this.channelManager.listAllChannels().size() + " channels";
        }
        String events = ", hooked " + TraitEventManager.getInstance().getRegisteredEventsAsName().size() + " Events";
        this.log(" loaded: " + traits + races + classes + channels + events);
        this.log(" " + this.description.getName() + " Version: '" + this.getDescription().getVersion() + "' fully loaded with Permissions: " + this.getPermissionManager().getPermissionsName());
        if (this.configManager.getGeneralConfig().isConfig_useAutoUpdater()) {
            this.checkForUpdates();
        }
    }

    private void checkForUpdates() {
        new Updater((Plugin)this, 58896, this.getFile(), Updater.UpdateType.DEFAULT, true);
    }

    private void setupConfiguration() {
        long timeTaken;
        this.configManager = new ConfigManager();
        this.configManager.getGeneralConfig().reload();
        long currentTime = System.currentTimeMillis();
        this.configManager.reload();
        this.setupDebugLogger();
        StartupStatisticCategory.PlayerConfigs.timeInMiliSeconds = timeTaken = System.currentTimeMillis() - currentTime;
    }

    private void setupDebugLogger() {
        if (!this.configManager.getGeneralConfig().isConfig_enableDebugOutputs()) {
            this.getDebugLogger().disable();
        }
        if (!this.configManager.getGeneralConfig().isConfig_enableErrorUpload()) {
            this.getDebugLogger().enableUploads(false);
        }
        this.getDebugLogger().setAlsoToPlugin(true);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public static RacesAndClasses getPlugin() {
        return plugin;
    }

    public long fullReload(boolean shutDownBefore, boolean useGC) {
        long time = System.currentTimeMillis();
        if (shutDownBefore) {
            this.shutDownSequenz(useGC);
        }
        this.initManagers();
        return System.currentTimeMillis() - time;
    }

    private void shutDownSequenz(boolean useGC) {
        PlayerScoreboardUpdater.stop();
        PermanentActionBarMessages.kill();
        this.playerManager.shutdown();
        this.getDebugLogger().shutDown();
        plugin.reloadConfig();
        this.cooldownManager.shutdown();
        this.channelManager.saveChannels();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        TraitStore.destroyClassLoaders();
        this.stunManager.deinit();
        this.dotManager.deinit();
        this.hotkeyManger.shutdown();
        this.debuffManager.shutdown();
        this.addinManager.shutdown();
        TranslationManagerHolder.shutdown();
        if (useGC) {
            System.gc();
        }
        PlayerSavingManager.shutdown();
    }

    public void fireEventToBukkit(Event event) {
        this.getServer().getPluginManager().callEvent(event);
    }

    public void fireEventIntern(Event event) {
        TraitEventManager.fireEvent(event);
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public AddinManager getAddinManager() {
        return this.addinManager;
    }

    public StatisticGatherer getStatistics() {
        return this.statistics;
    }

    public RaceManager getRaceManager() {
        return this.raceManager;
    }

    public ClassManager getClassManager() {
        return this.classManager;
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public ClassLoader getPluginsClassLoader() {
        return super.getClassLoader();
    }

    public StunManager getStunManager() {
        return this.stunManager;
    }

    public DotManager getDotManager() {
        return this.dotManager;
    }

    public HotsManager getHotsManager() {
        return this.hotsManager;
    }

    public SilenceAndKickManager getSilenceAndKickManager() {
        return this.silenceAndKickManager;
    }

    public HotkeyManager getHotkeyManager() {
        return this.hotkeyManger;
    }

    public InFightManager getInFightManager() {
        return this.inFightManager;
    }

    public BuffManager getBuffManager() {
        return this.buffManager;
    }

    public DebuffManager getDebuffManager() {
        return this.debuffManager;
    }

    public static boolean isVaultPresent() {
        return Bukkit.getPluginManager().getPlugin("Vault") != null;
    }

    public static boolean isBukkitInShutdownMode() {
        return isInShutdown;
    }
}

