/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.APIs;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.entitystatusmanager.stun.StunManager;
import de.tobiyas.util.RaC.player.PlayerUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class StunAPI {
    private static StunManager getStunManager() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        return plugin.getStunManager();
    }

    public static class StunEntity {
        public static boolean stunEntityForTicks(Entity entity, int time) {
            if (entity == null || time <= 0) {
                return false;
            }
            return StunAPI.getStunManager().stunEntity(null, entity, time);
        }

        public static boolean stunEntityForSeconds(Entity entity, int time) {
            if (entity == null || time <= 0) {
                return false;
            }
            return StunAPI.getStunManager().stunEntity(null, entity, time * 20);
        }

        public static boolean stunEntityForTicks(Entity stunner, Entity entity, int time) {
            if (entity == null || time <= 0) {
                return false;
            }
            return StunAPI.getStunManager().stunEntity(stunner, entity, time);
        }

        public static boolean stunEntityForSeconds(Entity stunner, Entity entity, int time) {
            return StunEntity.stunEntityForTicks(stunner, entity, time * 20);
        }

        public static boolean removeStun(Entity entity) {
            if (entity == null) {
                return false;
            }
            return StunAPI.getStunManager().removeStun(entity);
        }

        public static int getRemainingStunTimeInSeconds(Entity entity) {
            return StunEntity.getRemainingStunTimeInTicks(entity) / 20;
        }

        public static int getRemainingStunTimeInTicks(Entity entity) {
            if (entity == null) {
                return -1;
            }
            return StunAPI.getStunManager().getRestStunTime(entity);
        }
    }

    public static class StunPlayer {
        public static boolean stunPlayerForTicks(String playerName, int time) {
            return StunPlayer.stunPlayerForTicks(PlayerUtils.getPlayer(playerName), time);
        }

        public static boolean stunPlayerForSeconds(String playerName, int time) {
            return StunPlayer.stunPlayerForSeconds(PlayerUtils.getPlayer(playerName), time);
        }

        public static boolean stunPlayerForTicks(Player player, int time) {
            if (player == null || time <= 0) {
                return false;
            }
            return StunAPI.getStunManager().stunEntity(null, (Entity)player, time);
        }

        public static boolean stunPlayerForSeconds(Player player, int time) {
            if (player == null || time <= 0) {
                return false;
            }
            return StunAPI.getStunManager().stunEntity(null, (Entity)player, time * 20);
        }

        public static boolean stunPlayerForTicks(Entity stunner, Player player, int time) {
            if (player == null || time <= 0) {
                return false;
            }
            return StunAPI.getStunManager().stunEntity(stunner, (Entity)player, time);
        }

        public static boolean stunPlayerForSeconds(Entity stunner, Player player, int time) {
            return StunPlayer.stunPlayerForTicks(stunner, player, time * 20);
        }

        public static boolean removeStun(String playerName) {
            return StunPlayer.removeStun(PlayerUtils.getPlayer(playerName));
        }

        public static boolean removeStun(Player player) {
            if (player == null) {
                return false;
            }
            return StunAPI.getStunManager().removeStun((Entity)player);
        }

        public static int getRemainingStunTimeInSeconds(Player player) {
            return StunPlayer.getRemainingStunTimeInTicks(player) / 20;
        }

        public static int getRemainingStunTimeInTicks(Player player) {
            if (player == null) {
                return -1;
            }
            return StunAPI.getStunManager().getRestStunTime((Entity)player);
        }
    }
}

