/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.APIs;

import de.tobiyas.racesandclasses.RacesAndClasses;
import java.util.Map;

public class StatisticAPI {
    private static RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public static long getTotalTriggersOfTrait(String traitName) {
        Map<String, Long> triggerMap = plugin.getStatistics().getTraitsTriggersTotal();
        String realTraitName = null;
        for (String rTraitName : triggerMap.keySet()) {
            if (!rTraitName.equalsIgnoreCase(traitName)) continue;
            realTraitName = rTraitName;
        }
        if (realTraitName == null) {
            return -1L;
        }
        return triggerMap.get(realTraitName);
    }

    public static double getTotalTriggersOfTraitPerMinute(String traitName) {
        long triggers = StatisticAPI.getTotalTriggersOfTrait(traitName);
        if (triggers < 0L) {
            return -1.0;
        }
        double timeTotal = (double)plugin.getStatistics().getTimeRunning() / 60000.0;
        double eventsPerM = (double)triggers / timeTotal;
        return eventsPerM;
    }

    public static String getTimeRunning() {
        return plugin.getStatistics().getTimeRunningAsString();
    }

    public static long getEventsTriggeredTotal() {
        return plugin.getStatistics().getEventsTriggeredTotal();
    }

    public static double getEventsTotalPerMinute() {
        long numberOfEvents = plugin.getStatistics().getEventsTriggeredTotal();
        double timeTotal = (double)plugin.getStatistics().getTimeRunning() / 60000.0;
        double eventsPerM = (double)numberOfEvents / timeTotal;
        return eventsPerM;
    }

    public static long getTotalTraitsUsedTime() {
        Map<String, Long> timeMap = plugin.getStatistics().getTimeNeededTotal();
        long time = 0L;
        for (long timePerTrait : timeMap.values()) {
            time += timePerTrait;
        }
        return time;
    }

    public static long getTraitsUsedTime(String traitName) {
        Map<String, Long> timeMap = plugin.getStatistics().getTimeNeededTotal();
        String realTraitName = null;
        for (String rTraitName : timeMap.keySet()) {
            if (!rTraitName.equalsIgnoreCase(traitName)) continue;
            realTraitName = rTraitName;
        }
        if (realTraitName == null) {
            return -1L;
        }
        return timeMap.get(realTraitName);
    }
}

