/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.APIs;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.translation.TranslationManagerHolder;
import de.tobiyas.racesandclasses.translation.Translator;
import de.tobiyas.racesandclasses.translation.exception.TranslationNotFoundException;
import de.tobiyas.util.RaC.collections.HashMapUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LanguageAPI {
    public static Translator translateToCurrentLanguage(String tag) throws TranslationNotFoundException {
        return TranslationManagerHolder.getTranslationManager().translate(tag, false);
    }

    public static Translator translateToCurrentLanguageWithFallback(String tag) throws TranslationNotFoundException {
        return TranslationManagerHolder.getTranslationManager().translate(tag, true);
    }

    public static Translator translateIgnoreError(String tag) {
        try {
            return LanguageAPI.translateToCurrentLanguageWithFallback(tag);
        }
        catch (TranslationNotFoundException exp) {
            return new Translator(tag);
        }
    }

    public static String translate(RaCPlayer toTranslateTo, String tag, String ... arg) {
        Map<String, String> replacements = HashMapUtils.generateStringStringMap(arg);
        return LanguageAPI.translate(toTranslateTo, tag, replacements);
    }

    public static String translate(RaCPlayer toTranslateTo, String tag, Map<String, String> replacements) {
        try {
            Translator translator = LanguageAPI.translateIgnoreError(tag);
            if (translator == null) {
                return tag;
            }
            translator.setReplacePlayer(toTranslateTo);
            translator.replace(replacements);
            return translator.build();
        }
        catch (Throwable exp) {
            return new Translator(tag).build();
        }
    }

    public static boolean containsTranslation(String tag) {
        try {
            TranslationManagerHolder.getTranslationManager().translate(tag, true);
            return true;
        }
        catch (TranslationNotFoundException exp) {
            return false;
        }
    }

    public static void sendTranslatedMessage(CommandSender sender, String tag, Map<String, String> replacements) {
        String message;
        if (sender == null) {
            return;
        }
        if (replacements == null) {
            replacements = new HashMap<String, String>();
        }
        Translator translator = LanguageAPI.translateIgnoreError(tag);
        translator.replace(replacements);
        if (sender instanceof Player) {
            translator.setReplacePlayer(RaCPlayerManager.get().getPlayer((Player)sender));
        }
        if ("".equals(message = translator.build())) {
            return;
        }
        String pluginPre = LanguageAPI.translateIgnoreError("plugin_pre").build();
        sender.sendMessage(String.valueOf(pluginPre) + message);
    }

    public static void sendTranslatedMessage(CommandSender sender, String tag, String ... arg) {
        Map<String, String> replacements = HashMapUtils.generateStringStringMap(arg);
        LanguageAPI.sendTranslatedMessage(sender, tag, replacements);
    }

    public static void sendTranslatedMessage(CommandSender sender, String tag) {
        LanguageAPI.sendTranslatedMessage(sender, tag, new HashMap<String, String>());
    }

    public static void sendTranslatedMessage(RaCPlayer player, String tag, Map<String, String> replacements) {
        if (player == null) {
            return;
        }
        LanguageAPI.sendTranslatedMessage((CommandSender)player.getPlayer(), tag, replacements);
    }

    public static void sendTranslatedMessage(RaCPlayer player, String tag, String ... arg) {
        if (player == null) {
            return;
        }
        Map<String, String> replacements = HashMapUtils.generateStringStringMap(arg);
        LanguageAPI.sendTranslatedMessage(player, tag, replacements);
    }

    public static void sendTranslatedMessage(RaCPlayer player, String tag) {
        if (player == null) {
            return;
        }
        LanguageAPI.sendTranslatedMessage(player, tag, new HashMap<String, String>());
    }
}

