/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.APIs;

import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.RaceAPI;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.listeners.equipement.Listener_raceClassRestrictionOnItems;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemRestrictionAPI {
    public static void addRaceRestriction(ItemStack item, String raceName) {
        if (raceName == null) {
            return;
        }
        RaceContainer container = RaceAPI.getRaceByName(raceName);
        if (container == null) {
            return;
        }
        String pre = ChatColor.RED + Listener_raceClassRestrictionOnItems.RACE_RESTRICTION_PRE.get(0);
        String value = ChatColor.AQUA + container.getDisplayName();
        ItemRestrictionAPI.addStringToLore(item, pre, value);
    }

    public static void addClassRestriction(ItemStack item, String className) {
        if (className == null) {
            return;
        }
        ClassContainer container = ClassAPI.getClassByName(className);
        if (container == null) {
            return;
        }
        String pre = ChatColor.RED + Listener_raceClassRestrictionOnItems.CLASS_RESTRICTION_PRE.get(0);
        String value = ChatColor.AQUA + container.getDisplayName();
        ItemRestrictionAPI.addStringToLore(item, pre, value);
    }

    public static void addLevelRestriction(ItemStack item, int level) {
        if (level <= 0) {
            return;
        }
        String pre = ChatColor.RED + Listener_raceClassRestrictionOnItems.LEVEL_RESTRICTION_PRE.get(0);
        String value = "" + ChatColor.AQUA + level;
        ItemRestrictionAPI.addStringToLore(item, pre, value);
    }

    public static int getLevelRestiction(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (!item.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasLore()) {
            return 0;
        }
        for (String loreString : meta.getLore()) {
            loreString = loreString.toLowerCase();
            loreString = ChatColor.stripColor((String)loreString);
            for (String recog : Listener_raceClassRestrictionOnItems.LEVEL_RESTRICTION_PRE) {
                if (!loreString.startsWith(recog)) continue;
                String needed = loreString.split(": ")[1];
                try {
                    return Integer.parseInt(needed);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    private static void addStringToLore(ItemStack item, String pre, String value) {
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new LinkedList();
        ItemRestrictionAPI.removeOld(lore, pre);
        lore.add(String.valueOf(pre) + value);
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    private static void removeOld(List<String> lore, String pre) {
        pre = ChatColor.stripColor((String)pre);
        pre = pre.toLowerCase();
        Iterator<String> it = lore.iterator();
        while (it.hasNext()) {
            String toCheck = it.next();
            toCheck = ChatColor.stripColor((String)toCheck);
            if (!(toCheck = toCheck.toLowerCase()).startsWith(pre)) continue;
            it.remove();
        }
    }
}

