/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.APIs;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import java.util.List;
import java.util.Map;

public class CooldownApi {
    private static RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public static boolean hasCooldown(String playerName, String cooldownName) {
        return plugin.getCooldownManager().stillHasCooldown(playerName, cooldownName) > 0;
    }

    public static int getCooldownOfPlayer(String playerName, String cooldownName) {
        return plugin.getCooldownManager().stillHasCooldown(playerName, cooldownName);
    }

    public static void setPlayerCooldown(String playerName, String cooldownName, int timeInSeconds) {
        plugin.getCooldownManager().setCooldown(playerName, cooldownName, timeInSeconds);
    }

    public static void removeCooldown(String playerName, String cooldownName) {
        CooldownApi.setPlayerCooldown(playerName, cooldownName, -1);
    }

    public static List<String> getAllCooldownsOfPlayer(String playerName) {
        return plugin.getCooldownManager().getAllCooldownsOfPlayer(playerName);
    }

    public static Map<String, Integer> getAllCooldownsForPlayer(String playerName) {
        return plugin.getCooldownManager().getAllCooldownsForPlayer(playerName);
    }

    public static int getMaxCooldownForTrait(String playerName, String cooldown) {
        RaCPlayer pl = RaCPlayerManager.get().getPlayerByName(playerName);
        for (Trait trait : pl.getTraits()) {
            TraitWithRestrictions twrTrait;
            if (!(trait instanceof TraitWithRestrictions) || !(twrTrait = (TraitWithRestrictions)trait).getCooldownName().equals(cooldown)) continue;
            return twrTrait.getMaxUplinkTime();
        }
        return -1;
    }
}

