/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class Statistics {
    private static final Map<Plugin, LogClass> logmap = new HashMap<Plugin, LogClass>();
    private static long startTime = System.currentTimeMillis();

    public static void log(Plugin plugin, boolean sync, String name, int calls, long timeMS, long timeNano) {
        LogClass log = logmap.get(plugin);
        if (log == null) {
            log = new LogClass();
            logmap.put(plugin, log);
        }
        log.add(name, sync, calls, timeMS, timeNano);
    }

    public static void log(Plugin plugin, boolean sync, String name, long timeMS, long timeNano) {
        Statistics.log(plugin, sync, name, 1, timeMS, timeNano);
    }

    public static LogClass getLog(Plugin plugin) {
        return logmap.get(plugin);
    }

    public static void reset(Plugin plugin) {
        logmap.remove(plugin);
    }

    public static void resetAll() {
        logmap.clear();
        startTime = System.currentTimeMillis();
    }

    public static long lastRestart() {
        return startTime;
    }

    public static class LogEntry {
        private int calls = 0;
        private long timeMsNeeded = 0L;
        private long timeNanoNeeded = 0L;

        public void add(int calls, long timeMsNeeded, long timeNanoNeeded) {
            this.calls += calls;
            this.timeMsNeeded += timeMsNeeded;
            this.timeNanoNeeded += timeNanoNeeded;
        }

        public int getCalls() {
            return this.calls;
        }

        public long getTimeMsNeeded() {
            return this.timeMsNeeded;
        }

        public long getTimeNanoNeeded() {
            return this.timeNanoNeeded;
        }
    }

    public static class LogClass {
        private final Map<String, LogEntry> syncEntryMap = new HashMap<String, LogEntry>();
        private final Map<String, LogEntry> asyncEntryMap = new HashMap<String, LogEntry>();

        public void add(String name, boolean sync, int calls, long timeMsNeeded, long timeNanoNeeded) {
            LogEntry entry;
            LogEntry logEntry = entry = sync ? this.syncEntryMap.get(name) : this.asyncEntryMap.get(name);
            if (entry == null) {
                entry = new LogEntry();
                if (sync) {
                    this.syncEntryMap.put(name, entry);
                } else {
                    this.asyncEntryMap.put(name, entry);
                }
            }
            entry.add(calls, timeMsNeeded, timeNanoNeeded);
        }

        public Collection<String> presentSync() {
            return this.syncEntryMap.keySet();
        }

        public Collection<String> presentAsync() {
            return this.asyncEntryMap.keySet();
        }

        public LogEntry getSyncEntry(String name) {
            return this.syncEntryMap.get(name);
        }

        public LogEntry getAsyncEntry(String name) {
            return this.asyncEntryMap.get(name);
        }

        public long getTotalSyncTimeMS() {
            long time = 0L;
            for (LogEntry entry : this.syncEntryMap.values()) {
                time += entry.getTimeMsNeeded();
            }
            return time;
        }

        public long getTotalAsyncTimeMS() {
            long time = 0L;
            for (LogEntry entry : this.asyncEntryMap.values()) {
                time += entry.getTimeMsNeeded();
            }
            return time;
        }

        public long getTotalSyncTimeNano() {
            long time = 0L;
            for (LogEntry entry : this.syncEntryMap.values()) {
                time += entry.getTimeNanoNeeded();
            }
            return time;
        }

        public long getTotalAsyncTimeNano() {
            long time = 0L;
            for (LogEntry entry : this.asyncEntryMap.values()) {
                time += entry.getTimeNanoNeeded();
            }
            return time;
        }
    }
}

